package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSyncDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
public interface TimesheetService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Deprecated
    PagingVO<TimesheetVO> paging(TimesheetQuery query);

    /**
     * 工时详细审批
     *
     * @param query
     * @return
     */
    PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query);

    /**
     * 分组审批分页列表
     *
     * @param query 查询
     * @return {@link PagingVO}
     */
    PagingVO pagingGroup(TimesheetQuery query);

    /**
     * 分组审批列表
     *
     * @param query 查询
     * @return {@link List}<{@link TimesheetVO}>
     */
    List<TimesheetVO> listGroup(TimesheetQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetVO}>
     */
    List<TimesheetVO> queryList(TimesheetQuery query);

    List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query);

    /**
     * 统计
     *
     * @param query 查询
     * @return long
     */
    long count(TimesheetQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetVO}
     */
    TimesheetVO queryByKey(Long key);

    /**
     * 新增
     *
     * see com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService#insert(com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload)
     *
     * @param payload 单据数据
     * @return {@link TimesheetVO}
     */
    @Deprecated
    TimesheetVO insert(TimesheetPayload payload);

    /**
     * 修改
     *
     * see com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService#update(com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload)
     *
     * @param payload 单据数据
     * @return {@link TimesheetVO}
     */
    @Deprecated
    TimesheetVO update(TimesheetPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 撤销
     *
     * @param keys 键
     */
    @Deprecated
    void revoked(List<Long> keys);


    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Deprecated
    List<TimesheetVO> batchInsert(TimesheetListPayload payload);

    /**
     * 审批通过
     *
     * @param keys 键
     */
    void toApproved(List<Long> keys);

    /**
     * 高级审批
     *
     * @param keys 键
     */
    void toAdvanced(List<Long> keys);

    /**
     * 审批拒绝
     *
     * @param keys       键
     * @param apprResult 审批结果
     */
    void rejected(List<Long> keys, String apprResult);

    /**
     * 更新任务包工时当量信息
     *
     * @param taskIdSet 任务id集合
     */
    void updateTaskTimesheetEqva(List<Long> taskIdSet);

    /**
     * 查询工时与与之对应的关系
     *
     * @return
     */
    Map<Long, Long> getTimesheetAndPlanIds();

    /**
     * 查询工时4.0与5.0的关系
     *
     * @return
     */
    Map<Long, Long> getV4AndV5TimesheetIds();

    /**
     * 月度工时概览
     *
     * @param query
     * @return
     */
    Map<LocalDate, Object> getTimesheetOverview(TimesheetQuery query);

    /**
     * 月度工时校验
     *
     * @return
     */
    Boolean checkMonthlyTimesheet(String checkDate);

    /**
     * 工时列表变更审批人
     *
     * @param keys
     * @param apprUserId
     */
    void updateApprovingUser(List<Long> keys, Long apprUserId);


    /**
     * 生成法定假日工时
     *
     * @param param
     */
    void generateVacationPublicTimesheet(String param);

    /**
     * 生成请假工时
     *
     * @param applyId
     */
    void generateVacationPrivateTimesheet(Long applyId);


    /**
     * 工时填写企业微信自动提醒(BU/研发BU全员)
     */
    String timesheetAlertAll(Long employeeId);

    /**
     * 工时填写企业微信自动提醒-退回工时
     */
    String timesheetAlertAllBack(Long employeeId);


    /**
     * 工时填写企业微信自动提醒(上级)
     */
    String timesheetAlertSuperior();

    /**
     * 工时填写企业微信自动提醒(BU领导提醒)
     */
    String timesheetAlertBuLeader();

    /**
     * 工时填写的修改
     */
    void repairTimesheet();

    String timesheetApprovingAlert();

    /**
     * 检查创建和拒绝中 工时数据
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param userId    用户id
     * @return boolean 存在返回 true 不存在返回false
     */
    boolean checkTimeSheetStatueInCreateAndRejected(LocalDate startDate, LocalDate endDate, Long userId);

    /**
     * 法定假期（前一个月）-自动审核
     *
     * @param param
     */
    void taskApprovalTimesheet(String param);
}
