package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author sunxw
 * @description 用户假期申请VO
 * @Date 2023/5/8
 */
@Data
public class UserVacationApplyVO extends BaseViewModel implements Serializable {

    private String baseCity;
    @UdcName(udcName = "COM.CITY", codePropName = "baseCity")
    private String baseCityName;

    /**
     * 请假单id
     */
    private Long applyId;
    /**
     * 请假单号
     */
    private String applyNo;

    /**
     * 用户id
     */
    private Long userId;
    @UdcName(udcName = "USER", codePropName = "userId")
    private String userName;

    /**
     * 部门
     */
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    /**
     * 直属领导
     */
    private Long parentUserId;
    @UdcName(udcName = "USER", codePropName = "parentUserId")
    private String parentUserName;

    /**
     * 假期类型
     * 公假	OFFICIAL	10
     * 产前检查假	PRENATAL_EXA	20
     * 哺乳假	BREASTFEED	30
     * 事假	PERSONAL	40
     * 病假	SICK	50
     * 婚假	MARRIAGE	60
     * 丧假	FUNERAL	70
     * 法定年休	ANNUAL	80
     * 福利年休	ANNUAL_W	81
     * 产假	MATERNITY	90
     */
    private String vacationType;
    @UdcName(udcName = "org:vacation_type", codePropName = "vacationType")
    private String vacationTypeDesc;

    /**
     * 请假开始日
     */
    private LocalDate startDate;
    /**
     * 请假结束日
     */
    private LocalDate endDate;
    /**
     * 请假天数
     */
    private BigDecimal vacationDays;

    /**
     * 请假事由
     */
    private String reason;

    /**
     * 工作安排
     */
    private String workPlan;

    /**
     * 假期ID
     */
    private Long vacationId;

    /**
     * 补充附件标志
     */
    private Byte addFlag;

    /**
     * 补充附件清单
     */
    private String addList;

    /**
     * 状态
     */
    private ProcInstStatus apprStatus;
    private String apprStatusDesc;

    /**
     * 申请人ID
     */
    private Long apprUserId;
    @UdcName(udcName = "USER", codePropName = "apprUserId")
    private String apprUserName;

    /**
     * 申请日期
     */
    private LocalDateTime apprDate;

    private String apprDateStr;
    public String getApprDateStr() {
        if (apprDate != null) {
            return apprDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return apprDateStr;
    }
    /**
     * 删除标志
     */
    private Integer deleteFlag;

    /**
     * 是否是系统自动生成，0：否，1：是
     */
    private Byte autoSaveFlag;

    /**
     * 是否在项目上  0：否，1：是
     */
    private Byte inProjectFlag;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 休假日期
     */

    private LocalDate detailVDate;

    private String detailVDateStr;

    public String getDetailVDateStr() {
        if (detailVDate != null) {
            return detailVDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return detailVDateStr;
    }
    /**
     * 休假天数
     */
    private BigDecimal detailVDays;

    /**
     * v区间  0.5天区分上午下午 AM上午 PM下午
     */
    private String detailInterval;

    @ApiModelProperty("直属领导")
    private Long parentId;
    @UdcName(udcName = "USER", codePropName = "parentId")
    private String parentName;

//    @ApiModelProperty("所属公司")
//    private Long companyId;

    @ApiModelProperty("所属公司")
    private Long bookId;

    //    @UdcName(udcName = "COMPANY", codePropName = "companyId")
    private String companyName;

    @ApiModelProperty("主服务地")
    private String extString5;

    @ApiModelProperty("资源类型一")
    private String extString6;
    @ApiModelProperty("资源类型一")
    private String extString6Name;

    @ApiModelProperty("资源类型二")
    private String extString9;
    @ApiModelProperty("资源类型二")
    private String extString9Name;

    @ApiModelProperty("请假天数")
    private BigDecimal applyDays;

    @ApiModelProperty("附件")
    private String attachmentCodes;
    private Object attachmentDatas;

    @ApiModelProperty("补充附件")
    private String vacationAddAttachCodes;
    private Object vacationAddAttachDatas;

    @ApiModelProperty("附件说明")
    private String attachmentDesc;

    @ApiModelProperty("是否需要延长假期")
    private Byte extVacationFlag;

    @ApiModelProperty("延长原因")
    private String extVacationReson;

    @ApiModelProperty("补充附件")
    private String extVacationAttachCodes;
    private Object extVacationAttachDatas;
    
//    @ApiModelProperty("延长原因")
//    private String extVacationAttach;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("延长开始时间")
    private LocalDate extVacationStartDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("延长结束时间")
    private LocalDate extVacationEndDate;

    @ApiModelProperty("延长天数")
    private BigDecimal extVacationDays;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @ApiModelProperty("流程状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("可用假期")
    private List<UserVacationVO> availableVacationVOList;

    @ApiModelProperty("用户请假申请明细")
    private List<UserVacationApplyDetailVO> detailVOList;

    @ApiModelProperty("用户延长请假申请明细")
    private List<UserVacationApplyDetailVO> extDetailVOList;

    @ApiModelProperty("用户近三月休假明细")
    private List<UserRecentVacationApplyVO> lastThreeMonthDetailVOList;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    public String getApprStatusDesc() {
        if (null == apprStatus) {
            return "";
        }
        return apprStatus.getDesc();
    }


    private String resource;

    public String getResource(){
        return employeeNo+"-"+apprUserName;
    }
}
