package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;

/**
 * 业务伙伴管理-客户管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class BusinessCutomerManageVO extends BaseViewModel implements Serializable {
    /**
     * 地址簿id 用来和银行账户 基本信息 地址信息等关联
     */
    @ApiModelProperty("地址簿id 用来和银行账户 基本信息 地址信息等关联")
    private Long bookId;

    /**
     * 客户id
     */
    @ApiModelProperty("客户id")
    private Long businessCustomerInfoId;

    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;

    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("客户编号")
    @ExcelProperty(value = "客户编号", index = 0)
    private String customerNo;

    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称")
    @ExcelProperty(value = "客户名称", index = 1)
    private String partnerName;

    /**
     * 客户阶段 udc[crm:customer_stage]
     */
    @ApiModelProperty("客户阶段 udc[crm:customer_stage]")
    private String customerStage;

    /**
     * 客户阶段 udc[crm:customer_stage]
     */
    @ApiModelProperty("客户阶段 udc[crm:customer_stage]")
    @UdcName(udcName = "crm:customer_stage", codePropName = "customerStage")
    @ExcelProperty(value = "客户阶段", index = 2)
    private String customerStageDesc;

    /**
     * 客户级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    private String customerGradle;

    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    @UdcName(udcName = "crm:customer_grade", codePropName = "customerGradle")
    @ExcelProperty(value = "客户级别", index = 3)
    private String customerGradleDesc;

    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称拼音")
    private String partnerNamePinyin;


    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String customerStatus;

    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:STATUS", codePropName = "customerStatus")
    @ExcelProperty(value = "客户状态", index = 4)
    private String customerStatusDesc;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;

    /**
     * 行业 udc[crm:leads_customer_industry]
     */

    @ApiModelProperty("行业描述 udc[crm:leads_customer_industry]")
    @UdcName(udcName = "crm:leads_customer_industry", codePropName = "partnerIndustry")
    @ExcelProperty(value = "行业描述", index = 5)
    private String partnerIndustryDesc;

    /**
     * 客户来源 udc[crm:customer_source]
     */
    @ApiModelProperty("客户来源 udc[crm:customer_source]")
    private String customerSource;

    /**
     * 客户来源 udc[crm:customer_source]
     */
    @ApiModelProperty("客户来源 udc[crm:customer_source]")
    @UdcName(udcName = "crm:customer_source", codePropName = "customerSource")
    @ExcelProperty(value = "客户来源", index = 6)
    private String customerSourceDesc;

    /**
     * 客户经营状态
     */
    @ApiModelProperty("客户经营状态")
    private String custOperStatus;

    /**
     * 客户经营状态
     */
    @ApiModelProperty("客户经营状态")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:OPER_STATUS", codePropName = "custOperStatus")
    private String custOperStatusName;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    @ExcelProperty(value = "邮箱", index = 7)
    private String partnerEmail;

    /**
     * 传真
     */
    @ApiModelProperty("传真")
    @ExcelProperty(value = "传真", index = 8)
    private String partnerFax;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    @ExcelProperty(value = "电话", index = 9)
    private String partnerPhone;

    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String province;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String district;
    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detailAddress;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String provinceName;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String cityName;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String districtName;

    @ApiModelProperty("省市区")
    @ExcelProperty(value = "省市区", index = 10)
    private String address;


    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private Long serviceUserId;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    @ExcelProperty(value = "服务负责人", index = 11)
    private String serviceUserName;

    /**
     * 商务负责人
     */
    @ApiModelProperty("商务负责人")
    private Long businessUserId;

    /**
     * 商务负责人
     */
    @ApiModelProperty("商务负责人")
    @ExcelProperty(value = "商务负责人", index = 12)
    private String businessUserName;

    /**
     * 关怀负责人
     */
    @ApiModelProperty("关怀负责人")
    private Long careUserId;

    /**
     * 关怀负责人
     */
    @ApiModelProperty("关怀负责人")
    @ExcelProperty(value = "关怀负责人", index = 13)
    private String careUserName;

    /**
     * 运维售后负责人
     */
    @ApiModelProperty("运维售后负责人")
    private Long operationUserId;

    /**
     * 运维售后负责人
     */
    @ApiModelProperty("运维售后负责人")
    @ExcelProperty(value = "运维售后负责人", index = 14)
    private String operationUserName;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    @ExcelProperty(value = "创建者", index = 15)
    private String createUserName;

    /**
     * 记录创建者
     */
    @ApiModelProperty("创建时间")
    @ExcelProperty(value = "创建时间", index = 16)
    private String createTimeString;

    public String getCreateTimeString() {
        if (getCreateTime() != null) {
            return getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return createTimeString;
    }

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;

    /** 性质 udc[crm:company_nature] */
    @ApiModelProperty("性质描述 udc[crm:company_nature]")
    @UdcName(udcName = "crm:company_nature",codePropName = "partnerNature")
    private String partnerNatureDesc;


    /**
     * 是否是新客户
     */
    @ApiModelProperty("是否是新客户")
    private Boolean newCustFlag;
}
