package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyGradeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyGradeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyGradeSettingVO;

import java.util.List;

/**
 * 分级策略等级配置
 *
 * @author wangly
 * @date 2023-06-16
 */
public interface BusinessStrategyGradeSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyGradeSettingVO}>
     */
    PagingVO<BusinessStrategyGradeSettingVO> queryPaging(BusinessStrategyGradeSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyGradeSettingVO}>
     */
    List<BusinessStrategyGradeSettingVO> queryListDynamic(BusinessStrategyGradeSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyGradeSettingVO}
     */
    BusinessStrategyGradeSettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyGradeSettingVO}
     */
    BusinessStrategyGradeSettingVO insert(BusinessStrategyGradeSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyGradeSettingVO}
     */
    BusinessStrategyGradeSettingVO update(BusinessStrategyGradeSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyGradeSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 批量新增
     *
     * @param payloadList 单据数据集合
     * @param strategyId 分级策略id business_strategy.id
     */
    void saveAll(List<BusinessStrategyGradeSettingPayload> payloadList, Long strategyId);


    /**
     * 通过分级策略id(strategyId)查询
     *
     * @param strategyId business_strategy.id 分级策略id
     * @return {@link List<BusinessStrategyGradeSettingVO>}
     */
    List<BusinessStrategyGradeSettingVO> queryListByStrategyId(Long strategyId);

}
