package com.elitesland.tw.tw5.api.prd.pay.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 支付管理-付款发送记录
 *
 * @author wangly
 * @date 2023-12-12
 */
@Getter
@Setter
public class BkPayDetailRecordPayload extends TwCommonPayload  implements Serializable {
    /** 付款明细表id */
    @ApiModelProperty("付款明细表id")
    private Long bkPayDetailId;
    /** 流程实例号 */
    @ApiModelProperty("流程实例号")
    private String reqnbr;
    /** 事件实例号 */
    @ApiModelProperty("事件实例号")
    private String evtlst;
    /** 批次编号 */
    @ApiModelProperty("批次编号")
    private String bthnbr;
    /** 业务参考号 */
    @ApiModelProperty("业务参考号")
    private String yurref;
    /** 交易流水号 */
    @ApiModelProperty("交易流水号")
    private String refnbr;
    /** 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。 */
    @ApiModelProperty("请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。")
    private String reqsta;
    /** 交易序号 */
    @ApiModelProperty("交易序号")
    private String trxseq;
    /** 保留字段 */
    @ApiModelProperty("保留字段")
    private String rsv100;
    /** 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票 */
    @ApiModelProperty("付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票")
    private Integer payStatus;
    /** 单据类型：1.代发 2.支付（用于接口区分数据） */
    @ApiModelProperty("单据类型：1.代发 2.支付（用于接口区分数据）")
    private Integer orderType;
    /** 交易状态：E：失败 A: 登记 S: 成功 */
    @ApiModelProperty("交易状态：E：失败 A: 登记 S: 成功")
    private String stscod;
    /** 收方开户行名称 */
    @ApiModelProperty("收方开户行名称")
    private String crtbnk;
    /** 收方开户行地址 */
    @ApiModelProperty("收方开户行地址")
    private String crtadr;
    /** 收方行联行号 */
    @ApiModelProperty("收方行联行号")
    private String brdnbr;
    /** 交易金额 */
    @ApiModelProperty("交易金额")
    private BigDecimal trsamt;
    /** 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账 */
    @ApiModelProperty("业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账")
    private String ftnflg;
    /** 银行失败码 */
    @ApiModelProperty("银行失败码")
    private String errorCode;
    /** 批量标识:1.单条 2.批量  （用于支付接口） */
    @ApiModelProperty("批量标识:1.单条 2.批量  （用于支付接口）")
    private Integer batchFlag;
    /** 失败原因 */
    @ApiModelProperty("失败原因")
    private String errorReason;
}
