package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
@Getter
@Setter
public class PmsProjectQuery extends TwQueryParam implements Serializable {

    /**
     * 项目名称/编号 关键字查询
     */
    @ApiModelProperty("项目名称/编号")
    private String projectSearchKey;
    /**
     * 合同编号/名称
     */
    @ApiModelProperty("合同编号/名称")
    private String contractSearchKey;


    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    private String referCode;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private List<Long> deliBuIds;
    /**
     * 交付负责人id
     */
    @ApiModelProperty("交付负责人id")
    private Long deliUserId;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 销售负责人ID
     */
    @ApiModelProperty("销售负责人ID")
    private Long saleManUserId;

    /**
     * 项目状态类型0：不等于，1：等于
     */
    @ApiModelProperty("项目状态类型0：不等于，1：等于")
    private String projStatusType;

    /**
     * 产品编号标记 产品编码是否有值 1:已维护，0：未维护
     */
    @ApiModelProperty("产品编号标记 产品编码是否有值 1:已维护，0：未维护")
    private String productNoExit;
    /**
     * 关键资源状态  1 正常  0 异动（离职中4 已离职6）
     */
    @ApiModelProperty("关键资源状态  1 正常  0 异动（离职中4 已离职6）")
    private String projectResStatus;
    /**
     * 项目重要度 精确
     */
    @ApiModelProperty("项目重要度")
    private String projectImportance;
    /**
     * 预算总人天 精确
     */
    @ApiModelProperty("预算总人天")
    private BigDecimal totalDays;
    /**
     * 费用总成本 精确
     */
    @ApiModelProperty("费用总成本")
    private BigDecimal totalCost;
    /**
     * 工时结算周期 精确
     */
    @ApiModelProperty("工时结算周期")
    private String timesheetPeriod;
    /**
     * 项目名称 模糊
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 项目状态 精确
     */
    @ApiModelProperty("项目状态")
    private String projStatus;
    /**
     * 项目状态 精确
     */
    @ApiModelProperty("项目状态")
    private List<String> projStatusList;
    /**
     * 项目预算状态 精确
     */
    @ApiModelProperty("项目预算状态")
    private String budgetStatus;

    /**
     * 合同id 精确
     */
    @ApiModelProperty("合同id")
    private Long contractId;
    /**
     * 项目模板id 精确
     */
    @ApiModelProperty("项目模板id")
    private Long projTempId;
    /**
     * 客户行业 精确
     */
    @ApiModelProperty("客户行业")
    private String custIdst;
    /**
     * 客户区域 精确
     */
    @ApiModelProperty("客户区域")
    private String custRegion;
    /**
     * 预计开始日期 精确
     */
    @ApiModelProperty("预计开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate planStartDate;
    @ApiModelProperty("预计开始日期-区间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> planStartDateBetween;
    /**
     * 预计结束日期 精确
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    @ApiModelProperty("预计结束日期-区间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> planEndDateBetween;
    /**
     * 项目经理资源id 精确
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    /**
     * 项目经理当量系数 精确
     */
    @ApiModelProperty("项目经理当量系数")
    private BigDecimal pmEqvaRatio;
    /**
     * pmo资源负责人id 精确
     */
    @ApiModelProperty("pmo资源负责人id")
    private Long pmoResId;
    /**
     * pmo助理资源负责人id 精确
     */
    @ApiModelProperty("pmo助理资源负责人id")
    private Long pmoDeputyResId;
    /**
     * 总当量 精确
     */
    @ApiModelProperty("总当量")
    private BigDecimal totalEqva;
    /**
     * 派发当量（交付负责人-项目经理） 精确
     */
    @ApiModelProperty("派发当量（交付负责人-项目经理）")
    private BigDecimal distEqva;
    /**
     * 派发费用（交付负责人-项目经理） 精确
     */
    @ApiModelProperty("派发费用（交付负责人-项目经理）")
    private BigDecimal distCost;
    /**
     * 费用总预算 精确
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价 精确
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 允许外包 精确
     */
    @ApiModelProperty("允许外包")
    private Integer epibolyPermitFlag;
    /**
     * 允许转包 精确
     */
    @ApiModelProperty("允许转包")
    private Integer subcontractPermitFlag;
    /**
     * 非结算活动需要审批 精确
     */
    @ApiModelProperty("非结算活动需要审批")
    private Integer finishApproveFlag;
    /**
     * 最低保证金 精确
     */
    @ApiModelProperty("最低保证金")
    private BigDecimal deposit;
    /**
     * 关联项目 精确
     */
    @ApiModelProperty("关联项目")
    private Long relatedProjId;
    /**
     * 关联项目编号 模糊
     */
    @ApiModelProperty("关联项目编号")
    private String relatedProjNo;
    /**
     * 绩效规则 精确
     */
    @ApiModelProperty("绩效规则")
    private String performanceDesc;
    /**
     * 关闭原因 精确
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;

    /**
     * 差旅餐补限额 精确
     */
    @ApiModelProperty("差旅餐补限额")
    private BigDecimal maxTravelFee;
    /**
     * 项目编号 模糊
     */
    @ApiModelProperty("项目编号")
    private String projNo;
    /**
     * 项目编号 模糊
     */
    @ApiModelProperty("项目编号")
    private List<String> projNoList;
    /**
     * 完工百分比 精确
     */
    @ApiModelProperty("完工百分比")
    private BigDecimal compPercent;
    /**
     * 允许一人多任务包 精确
     */
    @ApiModelProperty("允许一人多任务包")
    private Integer muiltiTaskFlag;
    /**
     * 项目进度状态 精确
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;
    /**
     * 自动汇报标识 精确
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;
    /**
     * 每期确认金额 精确
     */
    @ApiModelProperty("每期确认金额")
    private BigDecimal reportPeriodAmt;
    /**
     * 汇报开始期间 精确
     */
    @ApiModelProperty("汇报开始期间")
    private LocalDate reportStartDate;
    /**
     * 汇报期间数 精确
     */
    @ApiModelProperty("汇报期间数")
    private Integer reportQty;
    /**
     * 包含客户承担费用标志 精确
     */
    @ApiModelProperty("包含客户承担费用标志")
    private Integer containsCustomerFlag;
    /**
     * 项目难度 精确
     */
    @ApiModelProperty("项目难度")
    private String projectDifficult;
    /**
     * 项目预算总开关标志 0:否 1:是 精确
     */
    @ApiModelProperty("项目预算总开关标志 0:否 1:是")
    private Integer budgetSwitchFlag;
    /**
     * 项目活动状态  精确
     */
    @ApiModelProperty("项目活动状态 ")
    private String projActivityStatus;
    /**
     * 项目活动审批状态  精确
     */
    @ApiModelProperty("项目活动审批状态 ")
    private String projActivityApprStatus;

    /**
     * 产品编号 模糊
     */
    @ApiModelProperty("产品编号")
    private String productNo;
    /**
     * 易道壳项目过程文档itemid 精确
     */
    @ApiModelProperty("易道壳项目过程文档itemid")
    private String processDocItemId;
    /**
     * 易道壳项目验收文档itemid 精确
     */
    @ApiModelProperty("易道壳项目验收文档itemid")
    private String acceptanceDocItemId;
    /**
     * 易道壳项目总结文档itemid 精确
     */
    @ApiModelProperty("易道壳项目总结文档itemid")
    private String summaryDocItemId;
    /**
     * 研发补贴金额 精确
     */
    @ApiModelProperty("研发补贴金额")
    private BigDecimal subsidyAmt;
    /**
     * 折旧月数 精确
     */
    @ApiModelProperty("折旧月数")
    private Integer depreciationMonths;
    /**
     * 折旧开始时间 精确
     */
    @ApiModelProperty("折旧开始时间")
    private LocalDateTime depreciationStartDate;

    /**
     * 督导资源id
     */
    @ApiModelProperty("督导资源id")
    private Long superResId;
    /**
     * 项目风险等级
     */
    @ApiModelProperty("项目风险等级")
    private String riskLevel;

    /**
     * 预计上线日期
     */
    @ApiModelProperty("预计上线日期")
    private LocalDate planOnlineDate;

    /**
     * 扩展字段1 项目类型
     */
    @ApiModelProperty("扩展字段1 项目类型")
    private String ext1;
    /**
     * 扩展字段2 模糊
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3 模糊
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4 模糊
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5 模糊
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /**
     * 帮我吧项目名称 模糊
     */
    @ApiModelProperty("帮我吧项目名称")
    private String bangwo8ProjName;

    /**
     * 是否筛选的全是外部项目
     */
    private Boolean isExternalProject = false;

    /**
     * 平台合同类型
     */
    @ApiModelProperty("平台合同类型")
    private String platType;

    private List<String> workTypes;
    /**
     * 无合同项目激活后代办提示 0:否 1:是
     */
    @ApiModelProperty("无合同项目激活后代办提示")
    private Integer noContractFlag;
    /**
     * 签单buid
     */
    @ApiModelProperty("签单buid")
    private Long signBuId;


    private List<Long> notInIds;

    private List<Long> inIds;

    /**
     * modifyTime
     */
    private LocalDateTime modifyTimeGt;

    /**
     * 合同客户id
     */
    private Long customerId;

    /**
     * 主子合同
     */
    private String mainType;
    /**
     * 资源规划更新日期
     */
    @ApiModelProperty("资源规划更新日期")
    private LocalDateTime planUpdateDate;

    @ApiModelProperty("通用文档类型配置主键")
    private Long configId;

    @ApiModelProperty("是否上传文档（通用文档）标记")
    private Boolean fileUploadFlag;

    @ApiModelProperty("汇报代办标记")
    private Boolean briefWorkFlag = false;
    /**
     * 权限判断
     */
    private Boolean permissionFlag = false;
    /**
     * 成本级别
     */
    @ApiModelProperty("成本级别")
    private String costLevel;

    /**
     * 确认开始时间开始
     */
    @ApiModelProperty("确认开始时间开始")
    private LocalDate jdeConfirmTimeStart;


    /**
     * 确认开始时间结束
     */
    @ApiModelProperty("确认开始时间结束")
    private LocalDate jdeConfirmTimeEnd;


    /**
     * JDE凭证号
     */
    @ApiModelProperty("JDE凭证号")
    private String jdeDocNo;

    /**
     * JDE凭证状态(成功、失败)
     */
    @ApiModelProperty("JDE凭证状态")
    private String jdeDocState;

    @ApiModelProperty("慧通同步标记")
    private Integer hwhtSyncFlag;


//    /**
//     * 项目结项创建时间
//     */
//    @ApiModelProperty("项目结项创建时间")
//    private LocalDateTime conclusionCreateTimeStart;
//
//
//    /**
//     * 项目结项创建时间
//     */
//    @ApiModelProperty("项目结项创建时间")
//    private LocalDateTime conclusionCreateTimeEnd;
}
