package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Getter
@Setter
public class PmsProjectMembersVO extends BaseViewModel implements Serializable {
    /**
     * 项目ID
     */
    @ApiModelProperty("项目ID")
    private Long projId;
    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private String role;
    /**
     * 复合能力ID
     */
    @ApiModelProperty("复合能力ID")
    private Long capasetLevelId;
    @ApiModelProperty("复合能力级别Desc")
    private String capasetLevelDesc;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;
    @UdcName(udcName = "USER", codePropName = "resId")
    private String resName;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;
    /**
     * 工作台默认显示
     */
    @ApiModelProperty("工作台默认显示")
    private Integer workbenchFlag;
    /**
     * 客户结算价
     */
    @ApiModelProperty("客户结算价")
    private BigDecimal customerPrice;

    @ApiModelProperty("任务详情")
    private List<TaskInfoVO> taskInfo;

    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

//    @ApiModelProperty("任务包ID")
//    private Long taskPackageId;

    /**
     * 任务包数量
     */
    @ApiModelProperty("任务包数量")
    private Integer taskPackageCount;


    @ApiModelProperty("资源状态")
    private String resourceStatus;
    @UdcName(udcName = "org:employee:resource", codePropName = "resourceStatus")
    private String resourceStatusDesc;
}
