package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Getter
@Setter
public class PurchaseContractManagerPayload extends TwCommonPayload implements Serializable {
    /**
     * 采购合同编号
     */
    @ApiModelProperty("采购合同编号")
    private String purchaseContractNo;
    /**
     * 采购合同名称
     */
    @ApiModelProperty("采购合同名称")
    private String purchaseContractName;
    /**
     * 平台合同类型 udc[salecon:plat_type]
     */
    @ApiModelProperty("平台合同类型 udc[salecon:plat_type]")
    private String platType;
    /**
     * 采购合同类型 udc[purchase:con_type]
     */
    @ApiModelProperty("采购合同类型 udc[purchase:con_type]")
    private String purchaseContractType;
    /**
     * 业务类型 udc[purchase:business_type]
     */
    @ApiModelProperty("业务类型 udc[purchase:business_type]")
    private String businessType;
    /**
     * 验收方式 udc[purchase:check]
     */
    @ApiModelProperty("验收方式 udc[purchase:check]")
    private String acceptanceType;
    /**
     * 采购公司地址簿Id
     */
    @ApiModelProperty("采购公司地址簿Id")
    private Long purchaseCompanyBookId;
    /**
     * 供应商地址簿ID
     */
    @ApiModelProperty("供应商地址簿ID")
    private Long supplierBookId;
    /**
     * 采购BU
     */
    @ApiModelProperty("采购BU")
    private Long purchaseBuId;
    /**
     * 采购负责人
     */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;
    /**
     * 签约日期
     */
    @ApiModelProperty("签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applicationDate;
    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currCode;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    private String contractStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 关联销售合同
     */
    @ApiModelProperty("关联销售合同")
    private Long relatedSalesContract;
    /**
     * 关联协议
     */
    @ApiModelProperty("关联协议")
    private Long relatedAgreement;
    /**
     * 比价资料
     */
    @ApiModelProperty("比价资料")
    private String pricecompereFileCodes;
    /**
     * 合同附件
     */
    @ApiModelProperty("合同附件")
    private String contractFileCodes;
    /**
     * 盖章附件
     */
    @ApiModelProperty("盖章附件")
    private String stampFileCodes;
    /**
     * 项目ID
     */
    @ApiModelProperty("项目ID")
    private Long relatedProjectId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String relatedProjectName;
    /**
     * 任务包
     */
    @ApiModelProperty("任务包")
    private Long relatedTask;
    /**
     * 开票方
     */
    @ApiModelProperty("开票方")
    private Long invoice;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /**
     * 采购来源
     */
    @ApiModelProperty("采购来源")
    private String contractSource;
    /**
     * 采购来源编号
     */
    @ApiModelProperty("采购来源编号")
    private String contractSourceNo;
    /**
     * 激活时间
     */
    @ApiModelProperty("激活时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime activateDate;
    /**
     * 终止原因
     */
    @ApiModelProperty("终止原因")
    private String overWhy;
    /**
     * 终止时间
     */
    @ApiModelProperty("终止时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime overDate;
    /**
     * 合同归档标志，0：未归档，1：归档
     */
    @ApiModelProperty("合同归档标志，0：未归档，1：归档")
    private Integer filingFlag;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime approvedTime;

    // 采购合同明细
    private List<PurchaseContractDetailsVO> purchaseDetailViews;

    // 采购付款计划
    private List<PurchasePaymentPlanVO> paymentPlanViews;

    @ApiModelProperty("流程提交标志")
    private Boolean submit = false;

    /**
     * 关闭原因
     */
    @ApiModelProperty("关闭原因")
    private String closeReason;

    /**
     * 关闭日期
     */
    @ApiModelProperty("关闭日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate closeDate;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;


    /**
     * 租赁开始日期
     */
    @ApiModelProperty("租赁开始日期")
    private LocalDate rentStartDate;
    /**
     * 租赁结束日期
     */
    @ApiModelProperty("租赁结束日期")
    private LocalDate rentEndDate;
    /**
     * 租赁期
     */
    @ApiModelProperty("租赁期")
    private Integer rentPeriod;
    /**
     * 月租金额
     */
    @ApiModelProperty("月租金额")
    private BigDecimal rentPrice;
    /**
     * 租赁总金额
     */
    @ApiModelProperty("租赁总金额")
    private String rentTotalAmt;

    /**
     * 租赁面积
     */
    @ApiModelProperty("租赁面积")
    private BigDecimal rentArea;

    /**
     * 租赁地址
     */
    @ApiModelProperty("租赁地址")
    private String rentAddress;
}
