package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceVerDetailPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 付款申请单
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Getter
@Setter
public class PurchasePaymentPayload extends TwCommonPayload  implements Serializable {
    // 基本信息
    /** 付款申请单编号 */
    @ApiModelProperty("付款申请单编号")
    private String paymentNo;
    /** 付款申请单类型 */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;
    /** 付款申请单名称 */
    @ApiModelProperty("付款申请单名称")
    private String purchaseName;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applicationDate;
    /** 付款公司地址簿Id */
    @ApiModelProperty("付款公司地址簿Id")
    private Long payCompanyBookId;
    /** 验收方式 */
    @ApiModelProperty("验收方式")
    private String acceptanceType;
    /** 付款金额（应付金额） */
    @ApiModelProperty("付款金额（应付金额）")
    private BigDecimal paymentAmt;
    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currPaymentAmt;
    /** 币种 */
    @ApiModelProperty("币种")
    private String currCode;
    /** 付款申请人 */
    @ApiModelProperty("付款申请人")
    private Long purchaseInchargeResId;
    /** 发票核销状态 */
    @ApiModelProperty("发票核销状态")
    private String invoiceState;
    /** 需求编号 */
    @ApiModelProperty("需求编号")
    private String demandNo;
    // 相关单据
    /** 关联单据类型 */
    @ApiModelProperty("关联单据类型")
    private String docType;
    /** 关联单据号 */
    @ApiModelProperty("关联单据号")
    private String docNo;
    /** 关联销售合同 */
    @ApiModelProperty("关联销售合同")
    private String relatedSalesContract;
    /** 关联项目号 */
    @ApiModelProperty("关联项目号")
    private String relatedProjectNo;
    /** 关联任务包 */
    @ApiModelProperty("关联任务包")
    private Long relatedTask;
    /** 付款依据 */
    @ApiModelProperty("付款依据")
    private String basisFileCodes;
    // 财务信息（申请人填写）
    /** 发票编号 */
    @ApiModelProperty("发票编号")
    private String invoiceNo;
    /** 发票金额 */
    @ApiModelProperty("发票金额")
    private BigDecimal invoiceAmt;
    /** 税率 */
    @ApiModelProperty("税率")
    private String rate;
    /** 税额 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmount;
    /** 建议付款方式 */
    @ApiModelProperty("建议付款方式")
    private String payMethod;
    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    private LocalDate payDate;
    /** 付款账期(天) */
    @ApiModelProperty("付款账期(天)")
    private Integer relatedDays;
    /** 收款人/单位BookId */
    @ApiModelProperty("收款人/单位BookId")
    private Long receivingUnitBookId;
    /** 收款账号 */
    @ApiModelProperty("收款账号")
    private String receivingId;
    /** 收款银行 */
    @ApiModelProperty("收款银行")
    private String receivingBank;
    /** 备注 财务信息(申请人填写)*/
    @ApiModelProperty("备注 财务信息(申请人填写)")
    private String accountingNote;
    // 记账信息（财务填写）
    /** 财务记账付款公司地址簿Id */
    @ApiModelProperty("财务记账付款公司地址簿Id")
    private Long finalPaymentCompanyBookId;
    /** 财务记账付款银行 */
    @ApiModelProperty("财务记账付款银行")
    private String finalPaymentBank;
    /** 财务记账付款账号 */
    @ApiModelProperty("财务记账付款账号")
    private String finalPaymentId;
    /** 财务记账记账科目 */
    @ApiModelProperty("财务记账记账科目")
    private Long finalAccountingSubject;
    /** 财务记账付款方式 */
    @ApiModelProperty("财务记账付款方式")
    private String finalPayMethod;
    /** 财务记账付款日期 */
    @ApiModelProperty("财务记账付款日期")
    private LocalDate finalPayDate;
    /** 财务记账备注 */
    @ApiModelProperty("财务记账备注")
    private String finalAccountingNote;

    @ApiModelProperty("生成资产卡片(是/否) 0：否；1：是")
    private String assetFlag;

    @ApiModelProperty("现金流量码")
    private String flowCode;

    @ApiModelProperty("入账模块类型")
    private String accountModuleType;

    @ApiModelProperty("预付款核销附件")
    private String fileCode;

    @ApiModelProperty("预付款附件")
    private String advanceFileCode;

    @ApiModelProperty("付款附件")
    private String paymentFileCode;
    /** 供应商 */
    @ApiModelProperty("供应商")
    private Long supplierLegalBookId;
    /** 紧急付款凭证 */
    @ApiModelProperty("紧急付款凭证")
    private String urgentPaymentCodes;
    /** 归属付款申请 */
    @ApiModelProperty("归属付款申请")
    private String attributionPayApply;
    /** 付款账期到期时间 */
    @ApiModelProperty("付款账期到期时间")
    private LocalDateTime expRelatedDate;
    /** 预计核销日期 */
    @ApiModelProperty("预计核销日期")
    private LocalDate expWriteOffDate;
    /** 付款银行 */
    @ApiModelProperty("付款银行")
    private String paymentBank;
    /** 付款账号 */
    @ApiModelProperty("付款账号")
    private String paymentId;
    /** 商机编号 */
    @ApiModelProperty("商机编号")
    private String opportunity;
    /** 记账科目 */
    @ApiModelProperty("记账科目")
    private Long accountingSubject;

    /** 状态 */
    @ApiModelProperty("状态")
    private String state;
    /** 流程场景 */
    @ApiModelProperty("流程场景")
    private String scene;
    /** 是否无发票核销：0：否；1：是 */
    @ApiModelProperty("是否无发票核销：0：否；1：是")
    private Integer noInvoiceVerification;
    /** 是否无单据核销：0：否；1：是 */
    @ApiModelProperty("是否无单据核销：0：否；1：是")
    private Integer noDocVerification;
    /** 预付款申请单编号 */
    @ApiModelProperty("预付款申请单编号")
    private String prePaymentNo;
    /** 财务记账付款核销日期 */
    @ApiModelProperty("财务记账付款核销日期")
    private LocalDate finalWriteOffDate;

    /** 实际付款日期 */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualPayDate;
    /** 判断该付款申请单是否需要上传凭证: 0：否；1：是 */
    @ApiModelProperty("判断该付款申请单是否需要上传凭证: 0：否；1：是")
    private Integer isNeedUpload;
    /** 支付标识：1.已支付 ；2.待支付 */
    @ApiModelProperty("支付标识：1.已支付 ；2.待支付")
    private Integer payFlag;
    /** 申请单事由描述 */
    @ApiModelProperty("申请单事由描述")
    private String reasonDesc;

    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


    /** 是否是提交流程 */
    @ApiModelProperty("是否是提交流程")
    private Boolean isSubmit = false;
    /** 费用承担部门 */
    @ApiModelProperty("费用承担部门")
    private List<CostUndertakeDepartmentPayload> costUndertakeDepartmentPayloads;
    /** 付款明细/计划 */
    @ApiModelProperty("付款明细/计划")
    private List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads;
    /** 付款计划参考（预付款）*/
    @ApiModelProperty("付款计划参考（预付款）")
    private List<PaymentPlanReferPayload> paymentPlanReferPayloads;
    /** 付款申请单记录 */
    @ApiModelProperty("付款申请单记录")
    private List<PaymentSlipPayload> paymentSlipPayloads;
    /** 提现申请单 */
    @ApiModelProperty("提现申请单")
    private List<ResWithdrawApplyPayload> resWithdrawApplyPayloads;
    /** 发票核销明细 */
    @ApiModelProperty("发票核销明细")
    private List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads;

    /** 票据核销明细 */
    @ApiModelProperty("票据核销明细")
    private List<BillVerDetailPayload> billVerDetailPayloads;

    /** 是否为驳回后再提交 */
    @ApiModelProperty("是否为驳回后再提交")
    private Boolean isResubmit;
    /** 是否为紧急付款 */
    @ApiModelProperty("是否为紧急付款")
    private Boolean urgentPaymentFlag;

    @ApiModelProperty("是否子帐")
    private String subAccountFlag;

    /** 费用承担bu 精确 */
    @ApiModelProperty("费用承担bu")
    private String expenseBuId;
}
