package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
public class SettleApplyDetailsPayload extends TwCommonPayload implements Serializable {
    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long settleApplyId;
    /**
     * 采购协议ID
     */
    @ApiModelProperty("采购协议ID")
    private Long purchaseAgreementId;
    /**
     * 关联资源id
     */
    @ApiModelProperty("关联资源id")
    private Long purchaseAgreementResId;
    /**
     * 结算资源ID
     */
    @ApiModelProperty("结算资源ID")
    private Long settleResId;
    /**
     * 结算开始日期
     */
    @ApiModelProperty("结算开始日期")
    private LocalDate startDate;
    /**
     * 结算结束日期
     */
    @ApiModelProperty("结算结束日期")
    private LocalDate endDate;
    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String coopWay;
    /**
     * 结算人天
     */
    @ApiModelProperty("结算人天")
    private BigDecimal settleDays;
    /**
     * 结算单价
     */
    @ApiModelProperty("结算单价")
    private BigDecimal settlePrice;
    /**
     * 结算金额
     */
    @ApiModelProperty("结算金额")
    private BigDecimal settleAmt;
    /**
     * 出差补贴单价
     */
    @ApiModelProperty("出差补贴单价")
    private BigDecimal businessTripPrice;
    /**
     * 出差补贴总额
     */
    @ApiModelProperty("出差补贴总额")
    private BigDecimal businessTripAmt;
    /**
     * 结算总额
     */
    @ApiModelProperty("结算总额")
    private BigDecimal settlerTotalAmt;
    /**
     * 出差天数
     */
    @ApiModelProperty("出差天数")
    private BigDecimal businessTripDays;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由号
     */
    @ApiModelProperty("事由号")
    private String reasonName;
//    /**
//     * 事由号
//     */
//    @ApiModelProperty("事由号")
//    private String reasonNo;
    /**
     * 子合同编号
     */
    @ApiModelProperty("子合同编号")
    private String saleContractNo;
    /**
     * 子合同id
     */
    @ApiModelProperty("子合同id")
    private Long saleContractId;
    /**
     * 项目归属bu
     */
    @ApiModelProperty("项目归属bu")
    private Long projectBelongBu;
    /**
     * 付款时间
     */
    @ApiModelProperty("付款时间")
    private LocalDate payTime;

    /**
     * 付款时间
     */
    @ApiModelProperty("付款时间")
    private String payTimeStr;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    private BigDecimal payAmt;
    /**
     * 付款状态
     */
    @ApiModelProperty("付款状态")
    private String payStatus;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;

}
