package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 结算申请
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
public class SettleApplyPayload extends TwCommonPayload implements Serializable {
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算单名称
     */
    @ApiModelProperty("结算单名称")
    private String settleName;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 申请人ID
     */
    @ApiModelProperty("申请人ID")
    private Long applyUserId;
    /**
     * 申请人部门ID
     */
    @ApiModelProperty("申请人部门ID")
    private Long applyUserBuId;
    /**
     * 单据状态
     */
    @ApiModelProperty("单据状态")
    private String status;
    /**
     * 结算人天
     */
    @ApiModelProperty("结算人天")
    private Integer settleDays;
    /**
     * 相关附件
     */
    @ApiModelProperty("相关附件")
    private String fileCodes;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;

    @ApiModelProperty("提交标记")
    private Boolean submitFlag = false;
    /**
     * 结算申请明细
     */
    @ApiModelProperty("结算申请明细")
    private List<SettleApplyDetailsPayload> detailsPayloadList;

    /**
     * 删除的明细id集合
     */
    @ApiModelProperty("删除的明细id集合")
    private List<Long> deleteIdList;
}
