package com.elitesland.tw.tw5.api.prd.purchase.vo;

import cn.zhxu.bs.bean.DbIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * 付款单记录汇总数据
 *
 * @author wangly
 * @date 2023-11-23
 */
@Data
@ExcelIgnoreUnannotated
public class PaymentSlipCollectExcelVO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    /**
     * 付款申请单ID
     */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /**
     * 付款流水号
     */
    @ApiModelProperty("付款流水号")
    @ExcelProperty(value = "付款流水号", index = 0)
    private String paySerialNum;

    /**
     * 付款申请单类型
     */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;

    /**
     * 付款申请单类型
     */
    @ApiModelProperty("付款申请单类型")
    @ExcelProperty(value = "付款申请单类型", index = 1)
    @UdcName(udcName = "purchase:payment_type", codePropName = "paymentApplicationType")
    private String paymentApplicationTypeDesc;
    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单编号")
    @ExcelProperty(value = "付款申请单编号", index = 2)
    private String paymentApplyNo;

    /**
     * 付款申请单名称
     */
    @ApiModelProperty("付款申请单名称")
    @ExcelProperty(value = "付款申请单名称", index = 3)
    private String paymentApplyName;

    /**
     * 付款事由
     */
    @ApiModelProperty("付款事由")
    @ExcelProperty(value = "付款事由", index = 4)
    private String reasonDesc;

    /**
     * 付款申请人
     */
    @ApiModelProperty("付款申请人")
    private Long purchaseInchargeResId;


    @ExcelProperty(value = "付款申请人", index = 5)
    @UdcName(udcName = "USER", codePropName = "purchaseInchargeResId")
    private String purchaseInchargeResName;


    /**
     * 费用承担bu
     */
    @ApiModelProperty("费用承担bu")
    private String expenseBuId;
    /**
     * 费用承担bu
     */
    @ApiModelProperty("费用承担bu")
    @ExcelProperty(value = "费用承担bu", index = 6)
    private String expenseBuName;

    /**
     * 关联产品
     */
    @ApiModelProperty("关联产品")
    @ExcelProperty(value = "关联产品", index = 7)
    private String relateProductName;

    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    @ExcelProperty(value = "付款金额", index = 8)
    private BigDecimal paymentAmt;

    /**
     * 付款日期
     */
    @ApiModelProperty("付款日期")
    private LocalDate paymentDate;

    /**
     * 付款日期
     */
    @ApiModelProperty("付款日期")
    @ExcelProperty(value = "付款日期", index = 9)
    private String paymentDateString;

    public String getPaymentDateString() {
        if (paymentDate != null) {
            return paymentDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return paymentDateString;
    }

    /**
     * 实际付款日期
     */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualDate;

    /**
     * 实际付款日期
     */
    @ApiModelProperty("实际付款日期")
    @ExcelProperty(value = "实际付款日期", index = 10)
    private String actualDateString;

    public String getActualDateString() {
        if (actualDate != null) {
            return actualDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return actualDateString;
    }

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String state;
    @ApiModelProperty("状态Desc")
    @UdcName(udcName = "purchase:payment_status", codePropName = "state")
    @ExcelProperty(value = "状态", index = 11)
    private String stateDesc;

    /**
     * 商机编号
     */
    @ApiModelProperty("商机编号")
    @ExcelProperty(value = "商机编号", index = 12)
    private String opportunity;

    /**
     * 商机名称
     */
    @ApiModelProperty("商机名称")
    @ExcelProperty(value = "商机名称", index = 13)
    private String opportunityName;

    /**
     * 关联销售合同编号
     */
    @ApiModelProperty("关联销售合同ID")
    private Long relatedSalesContractId;
    /**
     * 关联销售合同编号
     */
    @ApiModelProperty("关联销售合同编号")
    @ExcelProperty(value = "关联销售合同编号", index = 14)
    private String relatedSalesContract;
    /**
     * 关联销售合同名称
     */
    @ApiModelProperty("关联销售合同名称")
    @ExcelProperty(value = "关联销售合同名称", index = 15)
    private String relatedSalesContractName;


    /**
     * 客户bookId
     */
    @ApiModelProperty("客户bookId")
    private Long custId;

    /**
     * 关联销售合同名称
     */
    @ApiModelProperty("关联客户名称")
    @ExcelProperty(value = "关联客户名称", index = 16)
    private String relatedCustName;
    /**
     * 关联项目号
     */
    @ApiModelProperty("关联项目编号")
    @ExcelProperty(value = "关联项目编号", index = 17)
    private String relatedProjectNo;
    /**
     * 关联项目名称
     */
    @ApiModelProperty("关联项目名称")
    @ExcelProperty(value = "关联项目名称", index = 18)
    private String relatedProjectName;

    /**
     * 收款银行
     */
    @ApiModelProperty("收款银行")
    @ExcelProperty(value = "收款银行", index = 19)
    private String receivingBank;
    /**
     * 收款账号Id
     */
    @ApiModelProperty("收款账号Id")
    private String receivingAccount;
    /**
     * 收款账号Desc
     */
    @ApiModelProperty("收款账号Desc")
    @ExcelProperty(value = "收款账号", index = 20)
    private String receivingAccountDesc;

    /**
     * 付款银行
     */
    @ApiModelProperty("付款银行")
    @ExcelProperty(value = "付款银行", index = 21)
    private String paymentBank;
    /**
     * 付款账号Id
     */
    @ApiModelProperty("付款账号Id")
    private String paymentAccount;
    /**
     * 付款账号Desc
     */
    @ApiModelProperty("付款账号Desc")
    @ExcelProperty(value = "付款账号", index = 22)
    private String paymentAccountDesc;
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司")
    private Long payCompanyBookId;
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司")
    @ExcelProperty(value = "付款公司", index = 23)
    private String payCompanyBookIdDesc;


    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String docType;

    /**
     * 关联单据号
     */
    @ApiModelProperty("关联单据号")
    private String docNo;
}
