package com.elitesland.tw.tw5.api.prd.purchase.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author likunpeng
 * @date 2023/11/13
 * 付款申请单前置数据
 */
@Getter
@Setter
public class PurchasePaymentDefaultVO {

    /** 付款申请单类型 */
    @ApiModelProperty(value = "付款申请单类型")
    private String paymentApplicationType;
    /** 供应商BookId */
    @ApiModelProperty(value = "供应商BookId")
    private Long supplierBookId;
    /** 验收方式 */
    @ApiModelProperty(value = "验收方式")
    private String acceptanceType;
    /** 应付付款金额(付款明细本次付款金额累计) */
    @ApiModelProperty(value = "应付付款金额(付款明细本次付款金额累计)")
    private BigDecimal paymentAmt = BigDecimal.ZERO;
    /** 币种 */
    @ApiModelProperty(value = "币种")
    private String currCode;
    /** 关联单据类型 */
    @ApiModelProperty(value = "关联单据类型")
    private String docType;
    /** 关联单据号 */
    @ApiModelProperty(value = "关联单据号(编号)")
    private String docNo;
    /** 关联单据名称 */
    @ApiModelProperty(value = "关联单据名称")
    private String docName;
    /** 关联销售合同 */
    @ApiModelProperty(value = "关联销售合同(编号)")
    private String relatedSalesContract;
    /** 关联项目号 */
    @ApiModelProperty(value = "关联项目号(编号)")
    private String relatedProjectNo;

    /** 关联客户名称 */
    @ApiModelProperty(value = "关联客户名称")
    private String relatedCustName;
    /** 任务包 */
    @ApiModelProperty(value = "任务包")
    private Long relatedTask;
    /** 付款公司bookId */
    @ApiModelProperty(value = "付款公司bookId")
    private Long paymentCompanyBooKId;
    /** 需求编号 */
    @ApiModelProperty(value = "需求编号")
    private String demandNo;
    /** 付款方式 */
    @ApiModelProperty(value = "付款方式")
    private String payMethod;
    /** 收款人/单位BookId */
    @ApiModelProperty(value = "收款人/单位BookId")
    private Long receivingUnitBookId;
    /** 收款账号,多条数据选第一条/或者默认数据 */
    @ApiModelProperty(value = "收款账号,多条数据选第一条/或者默认数据")
    private String receivingId;
    /** 收款银行,多条数据选第一条/或者默认数据 */
    @ApiModelProperty(value = "收款银行,多条数据选第一条/或者默认数据")
    private String receivingBank;
    /** 关联单据ID */
    @ApiModelProperty(value = "关联单据ID")
    private Long docId;
    /** 采购合同类型 */
    private String purchaseContractType;
}
