package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 结算申请
 *
 * @author wangly
 * @date 2024-08-21
 */
@Getter
@Setter
public class SettleApplyVO extends BaseViewModel implements Serializable {
    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settleNo;
    /**
     * 结算单名称
     */
    @ApiModelProperty("结算单名称")
    private String settleName;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 申请人ID
     */
    @ApiModelProperty("申请人ID")
    private Long applyUserId;
    /**
     * 申请人一级部门负责人审批负责人
     */
    @ApiModelProperty("申请人一级部门负责人审批负责人")
    private Long applyUserBuLevel1Id;
    /**
     * 申请人名称
     */
    @ApiModelProperty("申请人名称")
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;
    /**
     * 申请人部门ID
     */
    @ApiModelProperty("申请人部门ID")
    private Long applyUserBuId;

    /**
     * 申请人部门名称
     */
    @ApiModelProperty("申请人部门名称")
    @UdcName(udcName = "BU", codePropName = "applyUserBuId")
    private String applyUserBuName;
    /**
     * 单据状态
     */
    @ApiModelProperty("单据状态")
    private String status;

    /**
     * 单据状态 udc[purchase:settle_apply:status]
     */
    @ApiModelProperty("单据状态 udc[purchase:settle_apply:status]")
    @UdcName(udcName = "purchase:settle_apply:status", codePropName = "status")
    private String statusDesc;
    /**
     * 结算人天
     */
    @ApiModelProperty("结算人天")
    private Integer settleDays;
    /**
     * 相关附件
     */
    @ApiModelProperty("相关附件")
    private String fileCodes;
    /**
     * 相关附件
     */
    @ApiModelProperty("相关附件")
    private Object fileDatas;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("流程审批状态")
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;
    /**
     *  结算申请明细
     */
    private List<SettleApplyDetailsVO> settleApplyDetailsVOList;
}
