package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 开票信息汇总
 *
 * @author likunpeng
 * @date 2023-07-19
 */

@Data
public class ConInvCollectQuery extends TwQueryParam implements Serializable {

    // 开票批次号
    @ApiModelProperty("开票批次号")
    private String batchNo;

    // 客户bookid
    @ApiModelProperty("客户客户bookid")
    private Long custId;

    //发票抬头
    @ApiModelProperty("发票抬头")
    private String invTitle;

    //合同编号/名称
    @ApiModelProperty("合同编号/名称")
    private String codeAndName ;

    @ApiModelProperty("发票状态")
    private String invStatus;


    // 实际开票日期开始
    @ApiModelProperty("实际开票日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate actualInvDateStart;

    // 实际开票日期结束
    @ApiModelProperty("实际开票日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate actualInvDateEnd;

    // 开票阶段（开票状态）
    @ApiModelProperty("开票阶段（开票状态）")
    private String batchStatus;


    // 实际收款日期开始
    @ApiModelProperty("实际收款日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate recvDateStart;

    // 实际收款日期开始
    @ApiModelProperty("实际收款日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate recvDateEnd;


    // 预计收款日期开始
    @ApiModelProperty("预计收款日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectReceDateStart;


    // 预计收款日期结束
    @ApiModelProperty("预计收款日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectReceDateEnd;

    // 交付BU
    @ApiModelProperty("交付BU")
    private Long deliBuId;


    // 交付负责人
    @ApiModelProperty("交付负责人")
    private Long deliUserId;

    // 签单BU
    @ApiModelProperty("签单BU")
    private Long signBuId;


    // 签单负责人
    @ApiModelProperty("签单负责人")
    private Long saleManUserId;

    // 售前BU
    @ApiModelProperty("售前BU")
    private Long preSaleBuId;


    // 售前负责人
    @ApiModelProperty("售前负责人")
    private Long preSaleUserId;

    // 项目经理
    @ApiModelProperty("项目经理")
    private Long pmResId;

    @ApiModelProperty("商品信息ID")
    private Long invItemId;

    // 销售大类
    @ApiModelProperty("销售大类")
    private String productClass;

    // 销售小类
    @ApiModelProperty("销售小类")
    private String productSubClass;

    // 发票号
    @ApiModelProperty("发票号")
    private String invNo;

    // 创建人
    @ApiModelProperty("创建人")
    private Long createUserId;

    // 创建时间开始
    @ApiModelProperty("创建时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeStart;

    // 创建时间结束
    @ApiModelProperty("创建时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeEnd;
}
