package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchInvdtlPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvCollectQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvCollectVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
public interface ConInvBatchInvdtlService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConInvBatchInvdtlVO}>
     */
    PagingVO<ConInvBatchInvdtlVO> queryPaging(ConInvBatchInvdtlQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConInvBatchInvdtlVO}>
     */
    List<ConInvBatchInvdtlVO> queryListDynamic(ConInvBatchInvdtlQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConInvBatchInvdtlVO}
     */
    ConInvBatchInvdtlVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConInvBatchInvdtlVO}
     */
    ConInvBatchInvdtlVO insert(ConInvBatchInvdtlPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConInvBatchInvdtlVO}
     */
    ConInvBatchInvdtlVO update(ConInvBatchInvdtlPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConInvBatchInvdtlPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 导出列表
     *
     * @param query
     * @param response
     */
    void exportList(ConInvBatchInvdtlQuery query, HttpServletResponse response) throws IOException;

    /**
     * 开票信息汇总查询
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConInvCollectVO}>
     */
    PagingVO<ConInvCollectVO> conInvCollectPaging(ConInvCollectQuery query);


}
