package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivableDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableDVO;

import java.util.List;

/**
 * 合同收款明细
 *
 * @author lemon
 * @date 2023-09-05
 */
public interface ConReceivableDService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConReceivableDVO}>
     */
    PagingVO<ConReceivableDVO> queryPaging(ConReceivableDQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConReceivableDVO}>
     */
    List<ConReceivableDVO> queryListDynamic(ConReceivableDQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConReceivableDVO}
     */
    ConReceivableDVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConReceivableDVO}
     */
    ConReceivableDVO insert(ConReceivableDPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConReceivableDVO}
     */
    ConReceivableDVO update(ConReceivableDPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConReceivableDPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 同步4.0
     * @param param
     */
    @Deprecated
    void syncConReceivableDTo4(String param);
}
