package com.elitesland.tw.tw5.api.prd.salecon.vo;

import cn.zhxu.bs.bean.DbIgnore;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
  * 合同开票批次
  *
  * @author likunpeng
  * @date 2023-07-19
  */
@Getter
@Setter
@ToString
public class ConInvBatchVO extends BaseViewModel implements Serializable {
    /** 批次号 */
    @ApiModelProperty("批次号")
    private String batchNo;
    /** 批次状态*/
    @ApiModelProperty("批次状态")
    private String batchStatus;

    @ApiModelProperty("批次状态")
    @UdcName(udcName = "con:inv:status", codePropName = "batchStatus")
    private String batchStatusDesc;

    /** prd_ab_invoice 发票信息ID */
    @ApiModelProperty("prd_ab_invoice 发票信息ID")
    private Long invoiceId;
    /** 发票抬头 */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /** 发票类型 */
    @ApiModelProperty("发票类型")
    private String invType;
    /** 发票类型 */
    @ApiModelProperty("发票类型")
    @UdcName(udcName = "prd:ab:inv_type", codePropName = "invType")
    private String invTypeDesc;
    /** 税率 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /** 递送方式 */
    @ApiModelProperty("递送方式")
    private String deliMethod;
    /** 递送方式 */
    @ApiModelProperty("递送方式")
    @UdcName(udcName = "con:inv:deli_method", codePropName = "deliMethod")
    private String deliMethodDesc;
    /** 收件人 */
    @ApiModelProperty("收件人")
    private String contactPerson;
    /** 收件人地址 文本录入 */
    @ApiModelProperty("收件人地址 文本录入")
    private String invAddr;
    /** 收件人电话 */
    @ApiModelProperty("收件人电话")
    private String invTel;
    /** 开户行 */
    @ApiModelProperty("开户行")
    private String bankName;
    /** 账号 */
    @ApiModelProperty("账号")
    private String accountNo;
    /** 开票日期 */
    @ApiModelProperty("开票日期")
    private LocalDate batchDate;
    /** 实际开票日期 */
    @ApiModelProperty("实际开票日期")
    private LocalDate actualInvDate;

    /** 发票内容 */
    @ApiModelProperty("发票内容")
    private String invContent;
    /** 付款方式 */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /** 付款方式 */
    @ApiModelProperty("付款方式")
    @UdcName(udcName = "con:inv:paymethod", codePropName = "payMethod")
    private String payMethodDesc;
    /** 开票说明 */
    @ApiModelProperty("开票说明")
    private String invDesc;
    /** 开票主体公司ID */
    @ApiModelProperty("开票主体公司ID")
    private Long invOuId;
    /** 开票主体公司ID */
    @ApiModelProperty("开票主体公司名称")
    private String invOuName;
    /** 开票金额(开票批次表) */
    @ApiModelProperty("开票金额")
    private BigDecimal batchInvAmt;
    /** 开票金额(开票发票表) */
    @ApiModelProperty("开票金额")
    private BigDecimal invAmt;
    /** 是否自动保存开票信息到地址簿 0 不保存 1保存 */
    @ApiModelProperty("是否自动保存开票信息到地址簿 0 不保存 1保存")
    private Integer saveAbFlag;
    /** 预计到账日期 */
    @ApiModelProperty("预计到账日期")
    private LocalDate antiRecvDate;
    /** 地址 存放地址簿中的信息 */
    @ApiModelProperty("地址 存放地址簿中的信息")
    private String addr;
    /** 退票原因 */
    @ApiModelProperty("退票原因")
    private String disDisc;
    /** 收件人邮箱 */
    @ApiModelProperty("收件人邮箱")
    private String invEmail;
    /** 发票商品ID 关联 T_INVOICE_ITEM.ID */
    @ApiModelProperty("发票商品ID 关联 T_INVOICE_ITEM.ID")
    private Long invItemId;

    /**
     * 关联发票商品信息字符串
     */
    private String goodsNameStr;

    /**
     * 关联发票商品信息
     */
    private InvItemVO invItemVO;
    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 客户地址簿号
     */
    @ApiModelProperty("客户地址簿号")
    private String custBookNo;

    /**
     * 主合同名称
     */
    @ApiModelProperty("主合同名称")
    private String contractName;
    private Long contractId;


    /**
     * 子合同id
     */
    private Long subContractId;

    /**
     * 子合同号
     */
    @ApiModelProperty("子合同号")
    private String subContractNo;

    /**
     * 子合同名称
     */
    @ApiModelProperty("子合同名称")
    private String subContractName;

    /**
     * 项目编号
     */
    private Long projId;

    /**
     * 项目编号
     */
    private String projNo;

    /**
     * 项目名称
     */
    private String projName;

    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    private String referCode;

    /** 项目经理*/
    @ApiModelProperty("项目经理")
    private Long pmUserId;

    /** 项目经理*/
    @ApiModelProperty("项目经理姓名")
    @UdcName(udcName = "USER", codePropName = "pmUserId")
    private String pmUserName;

    /** 销售人员*/
    @ApiModelProperty("销售人员")
    private Long saleManUserId;

    /** 项目经理*/
    @ApiModelProperty("销售人员")
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;


    /**
     * 提交人用户id
     */
    private Long createUserId;
    /**
     * 提交人
     */
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;

    /** 发票id*/
    @ApiModelProperty("发票id")
    private Long invId;

    /** 发票号码*/
    @ApiModelProperty("发票号码")
    private String invNo;

    /** 快递号码*/
    @ApiModelProperty("快递号码")
    private String deliveryNo;

    /** 净额*/
    @ApiModelProperty("净额")
    private BigDecimal netAmt;

    /** 税金*/
    @ApiModelProperty("税金")
    private BigDecimal taxAmt;

    /** 总账日期*/
    @ApiModelProperty("总账日期")
    private LocalDate ledgerDate;


    /** 收款计划id*/
    @ApiModelProperty("收款计划id")
    private Long planId;

    /** 收款阶段*/
    @ApiModelProperty("收款阶段")
    private String phaseDesc;

    /** 预计收款日期*/
    @ApiModelProperty("预计收款日期")
    private LocalDate expectRecvDate;

    /** 预计开票日期*/
    @ApiModelProperty("预计开票日期")
    private LocalDate expectInvDate;


    /** 主签约BU*/
    @ApiModelProperty("主签约BU")
    private Long signBuId;

    /** 主签约BU*/
    @ApiModelProperty("主签约BU")
    @UdcName(udcName = "BU", codePropName = "signBuId")
    private String signBuName;

    /** 交付BU*/
    @ApiModelProperty("交付BU")
    private Long deliBuId;

    /** 交付BU*/
    @ApiModelProperty("交付BU")
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;

    /** PMO*/
    @ApiModelProperty("PMO")
    private Long pmoUserId;

    /** PMO*/
    @ApiModelProperty("PMO")
    @UdcName(udcName = "USER", codePropName = "pmoUserId")
    private String pmoUserName;


    private String contractStatus;//子合同状态

    @UdcName(udcName = "salecon:status", codePropName = "contractStatus")
    private String contractStatusDesc;

    /**
     * 收款计划列表
     */
    List<ConReceivablePlanVO> receivablePlanVOS;

    /**
     * 合同相关开票信息列表
     */
    List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS;

    /**
     * 对方开票信息
     */
   // private PrdAbInvoiceVO prdAbInvoiceVO;
    private BookInvoiceVO prdAbInvoiceVO;
    /**
     * 己方开票信息
     */
    private BookInvoiceVO ouInvoiceVO;

    @ApiModelProperty("附件")
    private String fileCode;

    @ApiModelProperty("附件")
    private Object fileData;
    @ApiModelProperty("附件文件夹")
    private String folderId;

    /** 是否已经开票 */
    private Integer alreadyInvFlag;


    /**
     * 产品大类（销售合同的销售大类）
     */
    private String productClass;

    /**
     * 产品大类（销售合同的销售大类）
     */
    @UdcName(udcName = "con:sales_class", codePropName = "productClass")
    private String productClassDesc;

    /**
     * 邮件接收人（内部）
     */
    String recipientInner;
    /**
     * 邮件接收人（内部）
     */
    String recipientInnerDesc;

    /**
     * 邮件接收人（外部）
     */
    String recipientOuter;

    /** 是否自动开票:1 是；0 否 */
    private Integer invFlag;

    /** 邮件通知:1 是；0 否 */
    private Integer emailFlag;

    /** 开票备注，将开票说明加工后传递百望 */
    private String invRemark;


    /**销售子合同id(用于退票解绑后，记录销售子合同来源，项目汇报用此字段)*/
    private Long saleContractId;

    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;

    @DbIgnore
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;

    /**
     * 结算单已回收
     */
    @ApiModelProperty("结算单已回收")
    private Integer recycleSettleFlag;

    /**销售子合同id(用于退票解绑后，记录销售子合同来源，项目汇报用此字段)*/
    private String saleContractNo;

    /**
     * JDE客户编号
     */
    @ApiModelProperty("JDE客户编号")
    private String customerNo;
}
