package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Getter
@Setter
@ApiModel
public class ConInvCollectVO implements Serializable {


    // 开票批次ID
    @ApiModelProperty("开票批次ID")
    private Long invBatchId;
    // 开票批次号
    @ApiModelProperty("开票批次号")
    private String batchNo;

    // 客户名称
    @ApiModelProperty("客户名称")
    private String custName;

    //发票抬头
    @ApiModelProperty("发票抬头")
    private String invTitle;

    //合同编号
    @ApiModelProperty("合同编号")
    private String subContractNo ;

    // 合同名称
    @ApiModelProperty("合同名称")
    private String subContractName ;

    // 发票状态
    @ApiModelProperty("发票状态")
    private String invStatus;

    @ApiModelProperty("发票状态 udc[con:inv:inv_status]")
    @UdcName(udcName = "con:inv:inv_status", codePropName = "invStatus")
    private String invStatusDesc;

    // 实际开票日期
    @ApiModelProperty("实际开票日期")
    private LocalDate actualInvDate;

    // 批次开票金额
    @ApiModelProperty("批次开票金额")
    private BigDecimal invAmt;

    // 开票阶段（开票状态）
    @ApiModelProperty("开票阶段（开票状态）")
    private String batchStatus;

    @ApiModelProperty("开票阶段 udc[con:inv:status]")
    @UdcName(udcName = "con:inv:status", codePropName = "batchStatus")
    private String batchStatusDesc;

    // 实际收款日期
    @ApiModelProperty("实际收款日期")
    private LocalDate recvDate;

    // 实际收款金额
    @ApiModelProperty("实际收款金额")
    private BigDecimal recvAmt;

    // 预计收款日期
    @ApiModelProperty("预计收款日期")
    private LocalDate expectReceDate;

    // 交付BU
    @ApiModelProperty("交付BU")
    private Long deliBuId;

    @ApiModelProperty("交付BU")
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;

    // 交付负责人
    @ApiModelProperty("交付负责人")
    private Long deliUserId;

    @ApiModelProperty("交付负责人")
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    private String deliUserName;

    // 签单BU
    @ApiModelProperty("签单BU")
    private Long signBuId;

    @ApiModelProperty("签单BU")
    @UdcName(udcName = "BU", codePropName = "signBuId")
    private String signBuName;

    // 签单负责人
    @ApiModelProperty("签单负责人")
    private Long saleManUserId;

    @ApiModelProperty("签单负责人")
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;

    // 售前BU
    @ApiModelProperty("售前BU")
    private Long preSaleBuId;

    @ApiModelProperty("售前BU")
    @UdcName(udcName = "BU", codePropName = "preSaleBuId")
    private String preSaleBuName;

    // 售前负责人
    @ApiModelProperty("售前负责人")
    private Long preSaleUserId;

    @ApiModelProperty("售前负责人")
    @UdcName(udcName = "USER", codePropName = "preSaleUserId")
    private String preSaleUserName;



    // 项目经理
    @ApiModelProperty("项目经理")
    private Long pmResId;

    @ApiModelProperty("项目经理")
    @UdcName(udcName = "USER", codePropName = "pmResId")
    private String pmResName;

    // 发票商品信息
    @ApiModelProperty("发票商品信息")
    private String goodsCodeName;

    // 开票税率
    @ApiModelProperty("开票税率")
    private BigDecimal taxRate;

    // 销售大类
    @ApiModelProperty("销售大类")
    private String productClass;

    @ApiModelProperty("销售大类 udc[con:sales_class]")
    @UdcName(udcName = "con:sales_class", codePropName = "productClass")
    private String productClassDesc;

    // 销售小类
    @ApiModelProperty("销售小类")
    private String productSubClass;

    @ApiModelProperty("销售小类 udc[con:sales_sub_class]")
    @UdcName(udcName = "con:sales_sub_class", codePropName = "productSubClass")
    private String productSubClassDesc;

    // 不含税金额
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    // 税金
    @ApiModelProperty("税金")
    private BigDecimal taxAmt;

    // 合同税率
    @ApiModelProperty("合同税率")
    private BigDecimal saleConTaxRate;

    // 发票号
    @ApiModelProperty("发票号")
    private String invNo;

    // 快递单号
    @ApiModelProperty("快递单号")
    private String deliveryNo;

    // 创建人
    @ApiModelProperty("创建人")
    private Long createUserId;

    // 创建人
    @ApiModelProperty("创建人")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;

    // 创建时间
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

}
