package com.elitesland.tw.tw5.api.prd.salecon.vo;

import cn.zhxu.bs.bean.DbIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class ConReceivablePlanVO extends BaseViewModel implements Serializable {
    /**
     * 收款号
     */
    @ApiModelProperty("收款号")
    @ExcelProperty(index = 13, value = "收款号")
    private String receNo;
    /**
     * 收款阶段
     */
    @ApiModelProperty("收款阶段")
    @ExcelProperty(index = 14, value = "收款阶段")
    private String receStage;
    /**
     * 当期收款金额
     */
    @ApiModelProperty("当期收款金额")
    @ExcelProperty(index = 16, value = "当期收款金额")
    private BigDecimal receAmt = BigDecimal.ZERO;
    /**
     * 当期收款比例
     */
    @ApiModelProperty("当期收款比例")
    @ExcelProperty(index = 17, value = "当期收款比例 %")
    private BigDecimal receRatio;
    /**
     * 预计收款日期
     */
    @ApiModelProperty("预计收款日期")
    private LocalDate expectReceDate;
    @ExcelProperty(index = 18, value = "预计收款日期")
    private String expectReceDateStr;

    public String getExpectReceDateStr() {
        return ObjectUtils.isEmpty(this.expectReceDate) ? null : this.expectReceDate.toString();
    }

    /**
     * 开票批次ID[con_inv_batch]
     */
    private Long invBatchId;
    private String invBatchNo;
    /**
     * 收款状态
     */
    @ApiModelProperty("收款状态")
    private String receStatus;
    @ExcelProperty(index = 6, value = "收款状态")
    @UdcName(udcName = "salecon:payment_status", codePropName = "receStatus")
    private String receStatusDesc;
    /**
     * 预计开票日期
     */
    @ApiModelProperty("预计开票日期")
    private LocalDate expectInvDate;
    @ExcelProperty(index = 21, value = "预计开票日期")
    private LocalDate expectInvDateStr;

    public String getExpectInvDateStr() {
        return ObjectUtils.isEmpty(this.expectInvDate) ? null : this.expectInvDate.toString();
    }

    /**
     * 开票状态
     */
    @ApiModelProperty("开票状态(开票批次状态)")
    private String invStatus;
    @ExcelProperty(index = 7, value = "开票状态")
    @UdcName(udcName = "con:inv:status", codePropName = "invStatus")
    private String invStatusDesc;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ExcelProperty(index = 20, value = "税率")
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "taxRate")
    private String taxRateDesc;


    /**
     * 开票税率
     */
    @ApiModelProperty("开票税率")
    private BigDecimal invTaxRate;
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "invTaxRate")
    private String invTaxRateDesc;
    /**
     * 开票日期
     */
    @ApiModelProperty("开票日期")
    private LocalDate invDate;
    @ExcelProperty(index = 22, value = "开票日期")
    private String invDateStr;

    public String getInvDateStr() {
        return ObjectUtils.isEmpty(this.invDate) ? null : this.invDate.toString();
    }

    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    @ExcelProperty(index = 23, value = "已开票金额")
    private BigDecimal alreadyInvAmt = BigDecimal.ZERO;
    /**
     * 未开票金额
     */
    @ApiModelProperty("未开票金额")
    @ExcelProperty(index = 24, value = "未开票金额")
    private BigDecimal notInvAmt = BigDecimal.ZERO;
//    /**
//     * 已收款金额
//     */
//    @ApiModelProperty("已收款金额")
//    private BigDecimal alreadyReceAmt = BigDecimal.ZERO;
    /**
     * 实际收款日期
     */
    @ApiModelProperty("实际收款日期")
    private LocalDate actualReceDate;
    //    @ExcelProperty(index = 20,value = "实际收款日期")
    private String actualReceDateStr;

    public String getActualReceDateStr() {
        return ObjectUtils.isEmpty(this.actualReceDate) ? null : this.actualReceDate.toString();
    }

    /**
     * 未收款金额
     */
    @ApiModelProperty("未收款金额")
    @ExcelProperty(index = 26, value = "未收款金额")
    private BigDecimal notReceAmt = BigDecimal.ZERO;
    /**
     * 已确认金额
     */
    @ApiModelProperty("已确认金额")
    @ExcelProperty(index = 27, value = "已确认金额")
    private BigDecimal confirmedAmt = BigDecimal.ZERO;
    /**
     * 确认收入日期
     */
    @ApiModelProperty("确认收入日期")
    private LocalDate confirmedAmtDate;
    /**
     * 可分配金额
     */
    @ApiModelProperty("可分配金额")
    @ExcelProperty(index = 28, value = "可分配金额")
    private BigDecimal distAmt;

    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @ExcelProperty(index = 0, value = "客户名")
    private String custName;

    /**
     * 客户地址簿id
     */
    @ApiModelProperty("客户地址簿id")
//    @ExcelProperty(index = 0,value = "客户地址簿id")
    private Long custBookId;

    /**
     * 子合同ID
     */
    @ApiModelProperty("子合同ID")
    private Long saleConId;

    /**
     * 项目编号
     */
    private Long projId;

    /**
     * 项目编号
     */
    private String projNo;

    /**
     * 项目名称
     */
    private String projName;

    /**
     * 子合同ID
     */
    @ApiModelProperty("子合同ID")
    private Long saleConIdV4;
    /**
     * 子合同名称
     */
    @ApiModelProperty("子合同名称")
    @ExcelProperty(index = 3, value = "子合同名称")
    private String saleConName;

    /**
     * 子合同号
     */
    @ApiModelProperty("子合同号")
    @ExcelProperty(index = 2, value = "子合同号")
    private String saleConCode;
    /**
     * 主合同名称
     */
    @ApiModelProperty("主合同名称")
    @ExcelProperty(index = 1, value = "主合同名称")
    private String parentName;
    private Long parentId;
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    @ExcelProperty(index = 5, value = "参考合同号")
    private String referCode;
    /**
     * 子合同状态
     */
    @ApiModelProperty("子合同状态")
    private String saleConStatus;
    @ExcelProperty(index = 4, value = "子合同状态")
    @UdcName(udcName = "salecon:status", codePropName = "saleConStatus")
    private String saleConStatusDesc;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /**
     * 交付BU名称
     */
    @ExcelProperty(index = 9, value = "交付BU")
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;

    /**
     * 交付BU负责人ID
     */
    @ApiModelProperty("交付BU负责人ID")
    private Long deliBuInchargeUserId;

    /**
     * 交付负责人ID
     */
    @ApiModelProperty("交付负责人ID")
    private Long deliUserId;
    /**
     * 交付BU负责人
     */
    @ExcelProperty(index = 12, value = "BU负责人")
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    private String deliUserName;

    /**
     * 签单BUID
     */
    @ApiModelProperty("签单BUID")
    private Long signBuId;
    /**
     * 签单BU
     */
    @ApiModelProperty("签单BU")
    @UdcName(udcName = "BU", codePropName = "signBuId")
    private String signBuName;

    /**
     * 副签单BUID
     */
    @ApiModelProperty("副签单BUID")
    private Long coSignBuId;
    /**
     * 副签单负责人
     */
    @ApiModelProperty("副签单负责人")
    private Long coSignUserId;
    /**
     * 销售人员用户ID
     */
    @ApiModelProperty("销售人员用户ID")
    private Long saleManUserId;
    /**
     * 销售人用户名称
     */
    @ExcelProperty(index = 10, value = "销售人员")
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;
    /**
     * PMO用户ID
     */
    @ApiModelProperty("PMO用户ID")
    private Long pmoUserId;
    /**
     * PMO用户名称
     */
    @ExcelProperty(index = 11, value = "PMO")
    @UdcName(udcName = "USER", codePropName = "pmoUserId")
    private String pmoUserName;


    @ApiModelProperty("4.0收款计划id")
    private Long receivePlanIdV4;

    @ApiModelProperty("客户申请单号")
    private String relApllyNo;
    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    @ExcelProperty(index = 25, value = "已收款金额")
    private BigDecimal actualRecvAmt;

    /**
     * 实际收款日期
     */
    @ApiModelProperty("实际收款日期")
    private LocalDate actualRecvDate;
    @ExcelProperty(index = 19, value = "实际收款日期")
    private String actualRecvDateStr;

    public String getActualRecvDateStr() {
        return ObjectUtils.isEmpty(this.actualRecvDate) ? null : this.actualRecvDate.toString();
    }

    @ApiModelProperty("预计收款日期变更历史")
    private List<ConRecvplanChangeLogVO> recvDateChangeLogs;
    @ApiModelProperty("预计开票日期变更历史")
    private List<ConRecvplanChangeLogVO> invDateChangeLogs;

//    /**
//     * 主合同-签约公司id
//     */
//    @ApiModelProperty("主合同-签约公司id")
//    private Long ouId;

    /**
     * 主合同-签约公司id
     */
    @ApiModelProperty("主合同-签约公司id")
    private Long ouBookId;

    /**
     * 主合同-签约公司
     */
    @ApiModelProperty("主合同-签约公司")
    @ExcelProperty(index = 8, value = "签约公司")
    private String ouName;

    @ApiModelProperty("项目表-项目经理")
    private Long pmUserId;

    /**
     * 项目经理用户名称
     */
    @ExcelProperty(index = 29, value = "项目经理")
    @UdcName(udcName = "USER", codePropName = "pmUserId")
    private String pmUserName;

    @ApiModelProperty("客户请款单号")
    @ExcelProperty(index = 15, value = "相关请款号")
    private String relApplyNo;

    @ApiModelProperty("产品名称")
    private String prodName;

    @ApiModelProperty("合同开始日期")
    private LocalDate startDate;

    @ApiModelProperty("合同结束日期")
    private LocalDate endDate;

    /**
     * 子合同中的备注
     */
    private String contractRemark;

    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;

    @DbIgnore
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;

    @ApiModelProperty("发票抬头")
    private String invTitle;
//
     @ApiModelProperty("JDE客户编号")
     private String customerNo;

    @ApiModelProperty("业务伙伴id")
    private Long partnerId;

    @ApiModelProperty("收款账号")
    @ExcelProperty(index = 30, value = "收款账号")
    private String accountNo;

    @ApiModelProperty("户名")
    @ExcelProperty(index = 31, value = "户名")
    private String accountName;

    @ApiModelProperty("商品信息")
    @ExcelProperty(index = 32, value = "商品信息")
    private String goodsNameStr;

    /**
     * 产品大类
     */
    @ApiModelProperty("产品大类")
    private String productClass;

    /**
     * 产品大类
     */
    @ApiModelProperty("产品大类")
    @ExcelProperty(index = 33, value = "产品大类")
    @UdcName(udcName = "con:sales_class", codePropName = "productClass")
    private String productClassDesc;

    /**
     * 账户公司名称
     */
    @ApiModelProperty("账户公司名称")
    @ExcelProperty(index = 34, value = "公司")
    private String partnerName;

    /**
     * 开户网点
     */
    @ApiModelProperty("开户网点")
    @ExcelProperty(index = 35, value = "开户网点")
    private String depositBankOutlet;

    /** 账户信息ID */
    @ApiModelProperty("账户信息ID")
    private Long bookAccountId;
}
