package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 科目模板明细管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccSubjectTemplateDetailVO extends BaseViewModel implements Serializable {
    /**
     * 模板id
     */
    @ApiModelProperty("模板id")
    private Long tmplId;
    /**
     * 核算项目id
     */
    @ApiModelProperty("核算项目id")
    private Long businessId;
    /**
     * 上级id
     */
    @ApiModelProperty("上级id")
    private Long parentId;
    /**
     * 核算名称
     */
    @ApiModelProperty("核算名称")
    private String businessName;
    /**
     * 核算编号
     */
    @ApiModelProperty("核算编号")
    private String businessCode;
    /**
     * 预算项目id
     */
    @ApiModelProperty("预算项目id")
    private Long budgetId;
    /**
     * 预算名称
     */
    @ApiModelProperty("预算名称")
    private String budgetName;
    /**
     * 会计科目id
     */
    @ApiModelProperty("会计科目id")
    private Long accId;
    /**
     * 科目名称
     */
    @ApiModelProperty("科目名称")
    private String accName;
    /**
     * 是否考核
     */
    @ApiModelProperty("是否考核")
    private Boolean examineFlag;
    /**
     * 是否包含
     */
    @ApiModelProperty("是否包含")
    private Integer includeFlag;
    /**
     * 是否控制
     */
    @ApiModelProperty("是否控制")
    private Integer controlFlag;
    /**
     * 处理状态
     */
    @ApiModelProperty("处理状态")
    private String procStatus;
    /**
     * 处理信息
     */
    @ApiModelProperty("处理信息")
    private String procInfo;
    /**
     * 处理时间
     */
    @ApiModelProperty("处理时间")
    private LocalDateTime procTime;
    /**
     * 可配置字段1
     */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /**
     * 可配置字段2
     */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /**
     * 可配置字段3
     */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /**
     * 可配置字段4
     */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /**
     * 可配置字段5
     */
    @ApiModelProperty("可配置字段5")
    private String extStr5;

    /**
     * 税率
     */
    @Comment("税率（报销时用）")
    @Column()
    private BigDecimal taxRate;

}
