package com.elitesland.tw.tw5.api.prd.file.service;

import com.elitesland.tw.tw5.api.prd.file.payload.PrdFileFolderPayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileFolderQuery;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileFolderVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 附件 - 文件夹
 *
 * @author duwh
 * @date 2022/09/23
 */
public interface PrdFileFolderService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdFileFolderVO}
     */
    PrdFileFolderVO insert(PrdFileFolderPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdFileFolderVO}
     */
    PrdFileFolderVO update(PrdFileFolderPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdFileFolderVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link PrdFileFolderVO}>
     */
    List<PrdFileFolderVO> queryList(PrdFileFolderQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdFileFolderVO> paging(PrdFileFolderQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
}
