package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeDepartApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyBSVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartCheckVO;

public interface EmployeeDepartService {

    /**
     * 员工离职申请
     *
     * @param payload
     * @return
     */
    void employeeDepart(EmployeeDepartPayload payload);

    /**
     * 根据流程id查询离职申请详情
     *
     * @param prcoId
     * @return
     */
    EmployeeDepartApplyVO queryEmployeeDepart(String prcoId);

    /**
     * 根据员工id查询离职检查项
     *
     * @param employeeId
     * @return
     */
    EmployeeDepartCheckVO employeeDepartCheck(Long employeeId);

    /**
     * 员工离职申请列表分页查询
     *
     * @param query
     * @return
     */
    PagingVO<EmployeeDepartApplyVO> employeeDepartApplyList(EmployeeDepartApplyQuery query);

    /**
     * 数据权限-分页查询
     *
     * @param query
     * @return
     */
    PagingVO<EmployeeDepartApplyBSVO> permissionPaging(EmployeeDepartApplyQuery query);

    /**
     * 查询离职申请详情
     *
     * @param applyId
     * @return
     */
    EmployeeDepartApplyVO queryByKey(Long applyId);
}
