package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResPortrayalEvalConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEvaluateVO;

import java.math.BigDecimal;
import java.util.List;

public interface ResEvaluateService {

    /**
     * 获取员工评价信息
     *
     * @param userId
     * @return
     */
    ResEvaluateVO getResEvaluateScore(Long userId);


    /**
     * 更新资源画像评价展示配置
     *
     * @param payload
     * @return
     */
    void updateResPortrayalEvalConfig(ResPortrayalEvalConfigPayload payload);

    /**
     * 更新资源画像评价展示默认配置
     *
     * @param evalPointIds
     * @return
     */
    void updateResPortrayalEvalDefaultConfig(Long[] evalPointIds);

    /**
     * 获取资源关键评价点
     *
     * @param userId
     * @return
     */
    List<Long> getResPortrayalEvalPoints(Long userId);


    /**
     * 获取资源画像评价展示默认配置
     *
     * @param
     * @return
     */
    List<Long> getResPortrayalEvalDefaultConfig();

    /**
     * 获取资源画像评价展示配置
     *
     * @param
     * @return
     */
    List<Long> getResPortrayalEvalConfig(Long userId);


    /**
     * 获取资源项目综合评分
     *
     * @param
     * @return
     */
    BigDecimal getResProjEvaluateScore(Long userId);

}
