package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;

/**
 * @author sunxw
 * @description 用户假期申请查询
 * @Date 2023/5/8
 */
@Data
public class UserVacationApplyQuery extends TwQueryParam {

    /**
     * 请假单号
     */
    private String applyNo;

    /**
     * id集合
     */
    private List<Long> ids;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 组织id
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    private Long buVersionId;

    /**
     * 直属领导
     */
    private Long parentUserId;

    /**
     * 直属领导名字
     */
    private String presName;

    /**
     * 假期类型
     */
    private String vacationType;

    /**
     * 假期ID
     */
    private Long vacationId;

    /**
     * 请假开始日
     */
//    @TimeUtil.DATE
    private String vdateStart;
    /**
     * 请假结束日
     */
//    @TimeUtil.DATE
    private String vdateEnd;

    /**
     * 状态
     */
    private String apprStatus;


    /**
     * 申请日期
     */
    private List<String> apprDateStr;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("开始时间")
    private LocalDate startDate;

}
