package com.elitesland.tw.tw5.api.prd.my.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.List;

@Data
public class MobAttendanceResVO {

    private Long resId;//打卡资源ID

    private LocalDate attendanceDate;//打卡日期

    private Boolean attendanceHas;//是否已经打卡  true 1 false 0

    private Boolean attendanceComplete;//今天打卡是否已完成，针对上下班打卡

    @JsonIgnore
    private String attendanceTimeStart;//打卡规则中最晚上班打卡时间，T_ATTENDANCE_NORMAL_TIME.ATTENDACE_TIME_START

    @JsonIgnore
    private String attendanceTimeEnd;//打卡规则中最早下班打卡时间，T_ATTENDANCE_NORMAL_TIME.ATTENDACE_TIME_END

    private ResAttendanceVO attendanceInfo;//资源打卡信息

    private List<TAttendanceOtherVO> attendanceOther;//资源其他打卡信息

    public Boolean getAttendanceHas() {
        return attendanceInfo != null || (attendanceOther != null && attendanceOther.size() > 0);
    }

    public Boolean getAttendanceComplete() {
        if (attendanceInfo == null || attendanceTimeStart == null || attendanceTimeEnd == null) {
            return false;
        }
        if (!StringUtils.hasText(attendanceInfo.getAttendanceTimeStart()) ||
                !StringUtils.hasText(attendanceInfo.getAttendanceTimeEnd())) {
            return false;
        }
        int startTime = attendanceTimeStart.compareTo(attendanceInfo.getAttendanceTimeStart());
        int endTime = attendanceTimeEnd.compareTo(attendanceInfo.getAttendanceTimeEnd());
        if (startTime <= 0) {
            if (endTime >= 0) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

}
