package com.elitesland.tw.tw5.api.prd.personplan.payload;


import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;


/**
 * 项目沟通计划payload
 * @author wangxl
 * @date 2024/4/1
 */
@Data
@ApiModel(description = "项目沟通计划payload")
public class PmsCommunicatePlanPayload extends TwCommonPayload {

    /**
     * 沟通议程
     */
    @ApiModelProperty("沟通议程")
    private String title;

    /**
     * 关联计划
     */
    @ApiModelProperty("关联计划")
    private Long wbsId;

    /**
     * 关联计划
     */
    @ApiModelProperty("关联计划")
    private String wbsName;

    /**
     * 计划沟通时间
     */
    @ApiModelProperty("计划沟通时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime communicateTime;

    /**
     * 参与人 多的以,分割
     */
    @ApiModelProperty("参与人 多的以,分割")
    private String processingUser;

    /**
     * 状态 1待沟通 2已取消 3已结束
     */
    @ApiModelProperty("状态 1待沟通 2已取消 3已结束")
    private Integer status;

    /**
     * 处理时间
     */
    @ApiModelProperty("处理时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime processingTime;

    /**
     * 提醒提前时间(min) 多的以,分割
     */
    @ApiModelProperty("提醒提前时间(min) 多的以,分割")
    private String beforeRemindTime;
    /**
     * 提醒提前时间(min) 多的以,分割
     */
    @ApiModelProperty("提醒提前时间(min) 多的以,分割")
    private String beforeRemindTimeName;

    /**
     * 沟通内容
     */
    @ApiModelProperty("沟通内容")
    private String content;

    /**
     * 提醒方式
     */
    @ApiModelProperty("提醒方式 企微enterprise_wechat  邮件email 站内信instation")
    private String remindMode;


//    @ApiModelProperty("相关方id")
//    private Long relateId;
//
//
//    /**
//     * 情感倾向
//     */
//    @ApiModelProperty("情感倾向")
//    private Integer ext3;

    @ApiModelProperty("相关方情感倾向修改，需要id，ext3")
    private List<ProRelatedPartiesPayload> proRelatedPartiesPayloadList;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long proId;

//    /**
//     * 文件附件
//     */
//    @ApiModelProperty("文件附件")
//    private List<PmsFocusDocPayload> pmsFocusDocPayloadList;
}