package com.elitesland.tw.tw5.api.prd.personplan.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细
 */
@Data
@ApiModel(description = "人员规划明细")
public class PersonPlanDtlVO extends BaseViewModel{


    /**
     * 人员规划id
     */
    @ApiModelProperty("人员规划id")
    private Long planId;

    /**
     * 复合能力级别ID
     */

    @ApiModelProperty("复合能力级别ID")
    private Long capasetLevelId;

    @ApiModelProperty("复合能力级别ID")
    private String capasetLevelIdDesc;


    /**
     * 资源
     */
    @ApiModelProperty("资源")
    private Long resId;


    /**
     * 资源
     */
    @ApiModelProperty("资源")
    @UdcName(udcName = "USER",codePropName = "resId")
    private String resName;

    /**
     * 派发系数
     */

    @ApiModelProperty("派发系数")
    private BigDecimal distributeRate;
    /**
     * 汇总当量
     */
    @ApiModelProperty("汇总当量")
    private BigDecimal totalEqva;
    /**
     * 隐藏标志
     */
    @ApiModelProperty("隐藏标志")
    private Integer hiddenFlag;


    @ApiModelProperty("角色")
    private String roleCode;

    /**
     * 角色
     */
    @ApiModelProperty("角色")
    @UdcName(udcName = "PMS:RESOURCE_PLAN:ROLE",codePropName = "roleCode")
    private String roleName;

    /**
     * 投入精力
     */
    @ApiModelProperty("投入精力")
    private BigDecimal input;

    /**
     * 人天单价
     */
    @ApiModelProperty("人天单价")
    private BigDecimal price;

    /**
     * 人天合计
     */
    @ApiModelProperty("人天合计")
    private BigDecimal days;

    /**
     * 金额合计
     */
    @ApiModelProperty("金额合计")
    private BigDecimal amt;

    /**
     * 天数明细
     */
    @ApiModelProperty("天数明细")
    private String daysJson;

    /**
     * 创建人id
     */
    @ApiModelProperty("创建人id")
    private Long createUserId;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    @UdcName(udcName = "USER",codePropName = "createUserId")
    private String createUserName;


    /**
     * 相关方
     */
    @ApiModelProperty("相关方")
    private Long relatePartiesId;
    private String relatePartiesName;

    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private Long roleId;

    private List<PersonPlanDtlAndProjectVO> dtlAndProjectVOS;

}

