package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
@Getter
@Setter
public class PmsProjectSetPayload extends TwCommonPayload implements Serializable {
    /**
     * 父主键
     */
    @ApiModelProperty("父主键")
    private Long parentId;
    /**
     * 项目集名称
     */
    @ApiModelProperty("项目集名称")
    private String setName;
    /**
     * 项目集信息码
     */
    @ApiModelProperty("项目集信息码")
    private String setCode;
    /**
     * 项目集信息父节点码
     */
    @ApiModelProperty("项目集信息父节点码")
    private String parentSetCode;
    /**
     * node码
     */
    @ApiModelProperty("node码")
    private String nodeCode;
    /**
     * 负责人id
     */
    @ApiModelProperty("负责人id")
    private Long managerUserId;
    /**
     * 移除的项目ids
     */
    @ApiModelProperty("移除的项目ids")
    private List<Long> delProjectIds;
    /**
     * 添加的项目ids
     */
    @ApiModelProperty("添加的项目ids")
    private List<Long> addProjectIds;

    private BaseModel ProjectSetDO;
}
