package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 合同约束节点VO
 *
 * @author likunpeng
 * @date 2023-11-29
 */
@Getter
@Setter
public class ContractNodeVO {

    /** 收款计划ID（约束合同节点） */
    @ApiModelProperty("收款计划ID")
    private Long contractNode;

    /** 收款计划阶段（约束合同节点Desc） */
    @ApiModelProperty("收款计划阶段")
    private String receStage;

    /** 合同收款计划状态（合同节点状态） */
    @ApiModelProperty("合同收款计划状态（合同节点状态）")
    private String receStatus;
    @UdcName(udcName = "salecon:payment_status", codePropName = "receStatus")
    private String receStatusDesc;

    /** 当期应收款金额） */
    @ApiModelProperty("当期应收款金额")
    private BigDecimal receAmt;

    /** 已收款金额） */
    @ApiModelProperty("已收款金额")
    private BigDecimal actualRecvAmt;
}
