package com.elitesland.tw.tw5.api.prd.schedule.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/19 - 14:36
 */
@Data
public class PrdSchedulePayload extends TwCommonPayload {

    @ApiModelProperty("日程标题")
    private String title;

    @ApiModelProperty("日程描述")
    private String description;

    @ApiModelProperty("日程地址")
    private String location;

    @ApiModelProperty("全天")
    private Integer allDay;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("日历id")
    private Long calId;

    @ApiModelProperty("是否允许非参与人主动加入日程")
    private Integer allowActiveJoin=0;

    @ApiModelProperty("是否重复")
    private Integer isRepeat;

    @ApiModelProperty("是否提醒")
    private Integer isRemind=0;

    @ApiModelProperty("提前发送提醒时间")
    private Integer remindBeforeEventSecs;

    @ApiModelProperty("日程参与成员")
    private List<PrdScheduleAttendeesPayload> attendees;

    @ApiModelProperty("日程重复信息")
    private PrdScheduleRepeatPayload repeat;

    @Comment("企业微信主键")
    private String qyWxScheduleId;

    @Comment("来自企业微信的操作请求")
    private Boolean fromQyWx;

    @ApiModelProperty("不更新成员信息")
    private Boolean skipAttendees = false;

    @ApiModelProperty("不更新重复信息")
    private Boolean skipRepeat = false;


}
