package com.elitesland.tw.tw5.api.prd.system.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class PrdMessageConfigQuery extends TwQueryParam {

    /**
     * 消息编号
     */
    @ApiModelProperty("消息编号")
    private String messageCode;
    /**
     * 消息标题
     */
    @ApiModelProperty("消息标题")
    private String messageTitle;
    /**
     * 消息内容
     */
    @ApiModelProperty("消息内容")
    private String messageContent;
    /**
     * 消息类别
     */
    @ApiModelProperty("消息类型")
    private String contentType;
    /**
     * 消息大类
     */
    @ApiModelProperty("消息大类")
    private String contentBigType;
    /**
     * 发布来源， （以谁的名义发布该条消息，默认是个人）
     */
    @ApiModelProperty("发布来源")
    private String releaseSource;

    /**
     * 发布来源具体对象， （以谁的名义发布该条消息，个人，系统，组织，角色等，默认是个人）
     */
    private String createSource;

    /**
     * 通知方式
     */
    @ApiModelProperty("通知方式")
    private String noticeWay;
    /**
     * 通知范围
     */
    @ApiModelProperty("通知范围")
    private String noticeScope;
    /**
     * 通知范围的关联项，如果选择角色，部门，个人 提交以','分割id或编号
     */
    @ApiModelProperty("通知资源")
    private String noticeSource;
    /**
     * 触发方式 定时，业务
     */
    @ApiModelProperty("触发方式")
    private String triggerWay;
    /**
     * 定时发布（触发时间表达式）
     */
    @ApiModelProperty("触发时间表达式")
    private String triggerTimeExpression;
    /**
     * 发布时间起
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("发布时间起")
    private LocalDateTime releaseTimeStart;
    /**
     * 发布时间止
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("发布时间止")
    private LocalDateTime releaseTimeEnd;

    /**
     * 表达式说明
     */
    @ApiModelProperty("表达式说明")
    private String expressionExplain;
    /**
     * 消息标签
     */
    @ApiModelProperty("消息标签")
    private String messageTag;

    @ApiModelProperty("发布状态")
    private Integer releaseStatus;
    /**
     * 资源类型  1:运维人员，2:行政管理员
     */
    @ApiModelProperty("资源类型")
    private Integer messageType = 1;
    /**
     * 是否启用  0:启用，1：禁用
     */
    @ApiModelProperty("是否启用")
    private Integer isEnable;
}
