package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionRulePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionRuleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;

import java.util.List;

/**
 * 权限规则
 *
 * @Author Bill
 * @Date 2023/9/25 15:50
 **/
public interface PrdSystemPermissonRuleService {

    /**
     * 绑定数据规则
     * @param payload
     * @return
     */
    void insert(PrdSystemPermissionRulePayload payload);

    /**
     * 绑定数据删除
     * @param keys
     */
    void delete(Long[] keys);

    /**
     * 权限规则模糊分页
     * @param query
     * @return
     */
    PagingVO<PrdSystemPermissionRuleVO> paging(PrdSystemPermissionRuleQuery query);

    /**
     * 绑定数据修改
     * @param payload
     * @return
     */
    void update(PrdSystemPermissionRulePayload payload);

    /**
     * 主键查询
     * @param key
     * @return
     */
    PrdSystemPermissionRuleVO get(Long key);

    /**
     * 通过功能编码获取所有
     * @return 权限规则
     */
    List<PrdSystemPermissionRuleVO> getAllByFunctionCode(String functionCode);

    /**
     * 根据用户查询数据权限
     *
     * @param query
     * @return
     */
    PagingVO<PrdSystemPermissionRuleVO> pagingByUser(PrdSystemPermissionRuleQuery query);

    /**
     * 查询权限字段
     *
     * @param query
     * @return
     */
    List<PrdSystemPermissionFieldVO> listField(PrdSystemPermissionFieldQuery query);

    /**
     * 获取字段权限
     * @param objectCode 业务对象编码
     * @param className 类名
     * @return 字段权限
     */
    List<PrdSystemPermissionFieldObjRoleFunctionVO> getPermissionFieldRule(String objectCode, String className, String functionCode);
}
