package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;

import java.util.List;

/**
 * 人脉-工作经历
 *
 * @author carl
 * @date 2022/12/07
 */
public interface CrmPeopleWorkService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmPeopleWorkVO}
     */
    CrmPeopleWorkVO insertOrUpdate(CrmPeopleWorkPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmPeopleWorkVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @return {@link List}<{@link CrmPeopleWorkVO}>
     */
    List<CrmPeopleWorkVO> queryList(CrmPeopleWorkQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    //PagingVO<CrmPeopleWorkVO> paging(CrmPeopleWorkQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
