package com.elitesland.tw.tw5.api.prd.crm.vo;

import cn.zhxu.bs.bean.SearchBean;
import io.swagger.annotations.ApiModelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

/**
 * @Author carl.wang
 * @Description 商机合作伙伴
 * @Date
 **/

@Data
@SearchBean(
        tables = "crm_opportunity_partner cop",
        where = "cop.delete_flag = 0",
        autoMapTo = "cop"
)
public class CrmOpportunityPartnerVO extends BaseViewModel {
    /**
     * 商机ID
     */
    @ApiModelProperty("商机主键")
    private Long oppoId;
    /**
     * 合作伙伴名称
     */
    @ApiModelProperty("合作伙伴名称")
    private String partnerName;
    /**
     * 联系人
     */
    @ApiModelProperty("联系人")
    private String partnerContact;
    /**
     * 联系人邮箱
     */
    @ApiModelProperty("联系人邮箱")
    private String contactEmail;
    /**
     * 联系人电话
     */
    @ApiModelProperty("联系人电话")
    private String contactPhone;
    /**
     * 合作事项
     */
    @ApiModelProperty("合作事项")
    private String coopDesc;
    /**
     * 合作利益分配
     */
    @ApiModelProperty("合作利益分配")
    private String profitShare;


}
