package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonAccountVO;

import java.util.List;

public interface PersonAccountService {

    /**
     * 批量保存资源财务信息
     *
     * @param personAccountVOList
     * @param personId
     * @return
     */
    void saveAll(List<PersonAccountVO> personAccountVOList, Long personId);

    /**
     * 查询资源财务信息列表
     *
     * @param personId
     * @return
     */
    List<PersonAccountVO> findAllByPersonId(Long personId);

    /**
     * 删除资源财务信息
     *
     * @param personId
     * @return
     */
    void deleteAllByPersonId(Long personId);

    /**
     * 根据用户id查询资源财务信息列表
     *
     * @param userId
     * @return
     */
    List<PersonAccountVO> findAllByUserId(Long userId);
}
