package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdIndividAbilityVO;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 单项能力Service
 */

public interface PrdIndividAbilityService {

    /**
     * 新增单项能力数据
     *
     * @param prdIndividAbilityPayload
     * @return
     */
    PrdIndividAbilityVO save(PrdIndividAbilityPayload prdIndividAbilityPayload);

    /**
     * 根据主键更新
     *
     * @param prdIndividAbilityPayload
     * @return
     */
    PrdIndividAbilityVO update(PrdIndividAbilityPayload prdIndividAbilityPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdIndividAbilityVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdIndividAbilityQuery
     * @return
     */
    PagingVO<PrdIndividAbilityVO> page(PrdIndividAbilityQuery prdIndividAbilityQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);


    /**
     * 更改显示状态
     *
     * @param prdIndividAbilityPayload
     * @return
     */
    Long updateShow(PrdIndividAbilityPayload prdIndividAbilityPayload);

    /**
     * 更改有效无效
     *
     * @param prdIndividAbilityPayload
     * @return
     */
    Long updateState(PrdIndividAbilityPayload prdIndividAbilityPayload);

    /**
     * 单项能力-级别定义明细分页查询
     *
     * @param prdIndividAbilityQuery
     * @return
     */
    PagingVO<PrdIndividAbilityVO> levelPage(PrdIndividAbilityQuery prdIndividAbilityQuery);

    /**
     * 单项能力-级别定义明细列表查询
     *
     * @param prdIndividAbilityQuery
     * @return
     */
    List<PrdIndividAbilityVO> levelList(PrdIndividAbilityQuery prdIndividAbilityQuery);
}

