package com.elitesland.tw.tw5.api.prd.org.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@SearchBean(
        tables = "prd_org_employee employee " +
                "left join prd_org_person person on person.id = employee.person_id " +
                "left join prd_org_employee_ref ref on ref.user_id = employee.user_id and ref.is_default = 0 " +
                "and ref.is_copy = 0 and ref.delete_flag =0 " +
                "left join prd_org_organization org on org.id = ref.org_id and org.is_copy = 0 ",
        where = "person.delete_flag = 0 and (person.in_black_list=0 or person.in_black_list is null) and employee.resource_status not in ('1','2','6') ",
        autoMapTo = "employee"
)
@Data
public class PrdOrgEmployeeBSVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("用户真实姓名")
    @DbField(mapTo = "person")
    private String personName;

    @ApiModelProperty("系统用户ID")
    private Long userId;

    @ApiModelProperty("资源编号")
    private String resNo;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("资源状态名称")
    @DbIgnore
    private String resourceName;

    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;

    @ApiModelProperty("默认组织id")
    @DbField(mapTo = "ref")
    private Long orgId;

    @ApiModelProperty("默认组织名称")
    @DbField(mapTo = "org")
    private String orgName;

    @ApiModelProperty("上级ID")
    @DbField(mapTo = "ref")
    private Long parentId;

    @UdcName(udcName = "USER", codePropName = "parentId")
    @ApiModelProperty("上级员工名称")
    @DbIgnore
    private String parentName;

    @ApiModelProperty("专业级别")
    private String extString1;

    @ApiModelProperty("管理级别")
    private String extString2;

    @ApiModelProperty("专业序列")
    private String extString3;
    @UdcName(udcName = "org:employee:sequence", codePropName = "extString3")
    @DbIgnore
    private String extString3Name;

    @ApiModelProperty("职位序列")
    private String extString4;
    @UdcName(udcName = "org:employee:position", codePropName = "extString4")
    @DbIgnore
    private String extString4Name;

    @ApiModelProperty("主服务地址")
    private String extString5;

    @ApiModelProperty("内部类型")
    private String extString6;
    @UdcName(udcName = "org:employee:type", codePropName = "extString6")
    @DbIgnore
    private String extString6Name;

    @ApiModelProperty("资源类型二")
    private String extString9;
    @DbIgnore
    private String extString9Name;

    @ApiModelProperty("合同到期日")
    private LocalDate extDate4;

    @ApiModelProperty("资源经理")
    private Long resManagerId;
    @UdcName(udcName = "USER", codePropName = "resManagerId")
    @DbIgnore
    private String resManageName;

    @ApiModelProperty("自然人ID")
    @DbField("person.id")
    private Long personId;

    @ApiModelProperty("审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("备注")
    private String remark;

    public String getProcInstStatusDesc() {
        if (null == procInstStatus) {
            return "";
        }
        return procInstStatus.getDesc();
    }

}
