package com.elitesland.tw.tw5.api.prd.pms.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 预算主表payload
 *
 * @author duwh
 * @date 2024/3/7
 */
@Data
@ApiModel(description = "预算主表payload")
public class PmsWbsBudgetPayload extends TwCommonPayload {

    @ApiModelProperty("项目id")
    private Long proId;

    @ApiModelProperty("预算名称")
    private String objectName;

    @ApiModelProperty("预算编号")
    private String objectNo;

    @ApiModelProperty("单据状态 新建CREATE 审批中 APPROVING 激活 ACTIVE")
    private String objectStatus;

    @ApiModelProperty("版本 id")
    private Long versionId;

    @ApiModelProperty("版本号")
    private Integer versionNo;

    @ApiModelProperty("资源总预算")
    private BigDecimal totalResAmt;

    @ApiModelProperty("已结算资源预算")
    private BigDecimal totalSettledResAmt;

    @ApiModelProperty("已占用资源预算")
    private BigDecimal totalOccupiedResAmt;

    @ApiModelProperty("剩余资源预算（含待分配）")
    private BigDecimal totalRemainingResAmt;

    @ApiModelProperty("费用总预算")
    private BigDecimal totalFeeAmt;

    @ApiModelProperty("已结算费用预算")
    private BigDecimal totalSettledFeeAmt;

    @ApiModelProperty("已占用费用预算")
    private BigDecimal totalOccupiedFeeAmt;

    @ApiModelProperty("剩余费用预算（含待分配）")
    private BigDecimal totalRemainingFeeAmt;

    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime approvedTime;

    @ApiModelProperty("拓展字段1")
    private String extString1;

    @ApiModelProperty("拓展字段2")
    private String extString2;

    @ApiModelProperty("拓展字段3")
    private String extString3;

    @ApiModelProperty("拓展字段4")
    private String extString4;

    @ApiModelProperty("拓展字段5")
    private String extString5;

}
