package com.elitesland.tw.tw5.api.prd.pms.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * 预算释放表payload
 * @author duwh
 * @date 2024/3/7
*/
@Data
@ApiModel(description = "预算释放表payload")
public class PmsWbsBudgetReleasePayload extends TwCommonPayload {

    @ApiModelProperty("wbs 活动主键")
    private Long wbsId;

    @ApiModelProperty("版本 id")
    private Long versionId;

    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    @ApiModelProperty("当前分配预算")
    private BigDecimal allocatedResAmtBefore;

    @ApiModelProperty("已结算")
    private BigDecimal settledResAmtBefore;

    @ApiModelProperty("已占用")
    private BigDecimal occupiedResAmtBefore;

    @ApiModelProperty("剩余")
    private BigDecimal remainingResAmtBefore;

    @ApiModelProperty("当前分配预算")
    private BigDecimal allocatedResAmtAfter;

    @ApiModelProperty("已结算")
    private BigDecimal settledResAmtAfter;

    @ApiModelProperty("已占用")
    private BigDecimal occupiedResAmtAfter;

    @ApiModelProperty("剩余")
    private BigDecimal remainingResAmtAfter;

    @ApiModelProperty("变更量")
    private BigDecimal changeResAmt;

    @ApiModelProperty("确认结算")
    private BigDecimal confirmSettledRes;

    @ApiModelProperty("项目id")
    private Long proId;

}
