package com.elitesland.tw.tw5.api.prd.pms.payload;


import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 预算基本信息
 *
 * @author xiexb
 * @date 2023-04-24
 */
@Getter
@Setter
public class PmsBudgetPayload extends TwCommonPayload  implements Serializable {

    /** 项目id */
    @ApiModelProperty("项目id")
    private Long projectId;

    /** wbsid */
    @ApiModelProperty("wbsId")
    private Long wbsId;

    /** 预算模板id */
    @ApiModelProperty("预算模板id")
    private Long templateId;

    /** 开始时间 */
    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @FieldCreateLog(fieldName = "开始时间")
    @FieldUpdateLog(fieldName = "开始时间")
    private LocalDate startTime;

    /** 结束时间 */
    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @FieldCreateLog(fieldName = "结束时间")
    @FieldUpdateLog(fieldName = "结束时间")
    private LocalDate endTime;

    /**
     * 预算明细
     */
    @ApiModelProperty("预算明细")
    private List<PmsBudgetDetailPayload> budgetDetailList;




    /** 预算名称 */
    @ApiModelProperty("预算名称")
    @FieldCreateLog(fieldName = "预算名称")
    @FieldUpdateLog(fieldName = "预算名称")
    private String budgetName;

    /** 预算编号 */
    @ApiModelProperty("预算编号")
    private String budgetCode;



    /** 预算状态：新建、审批中、激活（已审批）、关闭 */
    @ApiModelProperty("预算状态：新建、审批中、激活（已审批）、关闭")
    private String budgetStatus;

    /** 费用总预算 */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalMoney;

    /** 预算附件 */
    @ApiModelProperty("预算附件")
    @FieldCreateLog(fieldName = "预算附件")
    @FieldUpdateLog(fieldName = "预算附件")
    private String budgetFiles;

    /** 预算控制：刚性控制、柔性控制、不控制 */
    @ApiModelProperty("预算控制：刚性控制、柔性控制、不控制")
    private String budgetControl;

    /** 币种 */
    @ApiModelProperty("币种]")
    private String currCode;

    /**
     * 流程提交标志
     */
    @ApiModelProperty("流程提交标志")
    private Boolean submit = false;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 预算详细明细-科目
     */
    @ApiModelProperty("预算详细明细-科目")
    private List<PmsBudgetDetailSubjectPayload> subjectList;

    /**
     * 变更提交标志
     */
    @ApiModelProperty("变更提交标志")
    private Boolean change = false;

    /**
     * 变更简述
     */
    @ApiModelProperty("变更简述")
    private String changeDescription;

    /**
     * 变更说明
     */
    @ApiModelProperty("变更说明")
    private String changeContent;


    @ApiModelProperty("已完成拨付的金额")
    private BigDecimal paidMoney;

    @ApiModelProperty("已使用预算金额")
    private BigDecimal usedMoney;

    @ApiModelProperty("使用占比")
    private BigDecimal proportion;

    @ApiModelProperty("可使用金额")
    private BigDecimal residueMoney;

    @ApiModelProperty("可申请金额")
    private BigDecimal mayApplyMoney=BigDecimal.ZERO;

    /**
     * 拨付占比
     */
    @ApiModelProperty("拨付占比")
    private BigDecimal appropriationProportion;


}
