package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 项目wbs前置依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
@Getter
@Setter
public class PmsProjectWbsRelyQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * wbs主键(依赖建立着，后置任务) 精确
     */
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)")
    private Long wbsId;
    /**
     * wbs主键(依赖建立着，后置任务) 精确
     */
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)")
    private List<Long> wbsIdList;
    /**
     * wbs名称(依赖建立着，后置任务，冗余字段) 精确
     */
    @ApiModelProperty("wbs名称(依赖建立着，后置任务，冗余字段)")
    private String wbsName;
    /**
     * wbs主键(依赖前置任务) 精确
     */
    @ApiModelProperty("wbs主键(依赖前置任务)")
    private Long wbsRelyId;
    /**
     * wbs名称(前置依赖名称，冗余字段） 精确
     */
    @ApiModelProperty("wbs名称(前置依赖名称，冗余字段）")
    private String wbsRelyName;
    /**
     * 前置类型（FS） 精确
     */
    @ApiModelProperty("前置类型（FS）")
    private String relyType;

    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;
}
