package com.elitesland.tw.tw5.api.prd.pms.vo;


import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
  * 预算详细明细-科目
  *
  * @author xxb
  * @date 2023-04-24
  */
@Getter
@Setter
public class PmsBudgetDetailSubjectVO extends BaseViewModel implements Serializable {
    /** 项目id */
    @ApiModelProperty("项目id")
    private Long projectId;
    /** 科目主键 */
    @ApiModelProperty("科目主键")
    private Long subjectId;
    /** 科目父主键 */
    @ApiModelProperty("科目父主键")
    private Long subjectParentId;
    /** 科目编号 */
    @ApiModelProperty("科目编号")
    private String subjectCode;
    /** 科目名称 */
    @ApiModelProperty("科目名称")
    private String subjectName;
    /** 父科目编码 */
    @ApiModelProperty("父科目编码")
    private String parentSubjectCode;
    /** wbs编码 */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    /** 预算金额 */
    @ApiModelProperty("预算金额")
    private BigDecimal totalMoney;
    /**
     * 已使用预算金额
     */
    @ApiModelProperty("已使用预算金额")
    private BigDecimal usedMoney;

    /**
     * 使用占比
     */
    @ApiModelProperty("使用占比")
    private BigDecimal proportion;

    /**
     * 层级
     */
    @ApiModelProperty("层级")
    private Integer subjectLevel;


}
