package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 预算基本信息
 *
 * @author xiexb
 * @date 2023-04-24
 */
@Getter
@Setter
public class PmsBudgetVO extends BaseViewModel implements Serializable {
    /**
     * 预算名称
     */
    @ApiModelProperty("预算名称")
    private String budgetName;
    /**
     * 预算编号
     */
    @ApiModelProperty("预算编号")
    private String budgetCode;
    /**
     * 预算模板id
     */
    @ApiModelProperty("预算模板id")
    private Long templateId;
    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private LocalDate startTime;
    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private LocalDate endTime;
    /**
     * 预算状态：新建、审批中、激活（已审批）、关闭
     */
    @ApiModelProperty("预算状态：新建、审批中、激活（已审批）、关闭")
    private String budgetStatus;
    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalMoney;
    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;

    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private Object budgetFilesDatas;


    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /** wbsid */
    @ApiModelProperty("wbsId")
    private Long wbsId;

    /**
     * 预算控制：刚性控制、柔性控制、不控制
     */
    @ApiModelProperty("预算控制：刚性控制、柔性控制、不控制")
    private String budgetControl;

    /**
     * 币种
     */
    @ApiModelProperty("币种]")
    private String currCode;
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    private String currCodeName;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 预算详细明细-科目
     */
    @ApiModelProperty("预算详细明细-科目")
    private List<PmsBudgetDetailSubjectVO> subjectList;


    /**
     * 已完成拨付的金额
     */
    @ApiModelProperty("已完成拨付的金额")
    private BigDecimal paidMoney;

    /**
     * 已使用预算金额
     */
    @ApiModelProperty("已使用预算金额")
    private BigDecimal usedMoney;

    /**
     * 使用占比
     */
    @ApiModelProperty("使用占比")
    private BigDecimal proportion;

    /**
     * 可使用金额
     */
    @ApiModelProperty("可使用金额")
    private BigDecimal residueMoney;

    /**
     * 拨付编码
     */
    @ApiModelProperty("拨付编码")
    private String appropriationCode;

    /**
     * 拨付占比
     */
    @ApiModelProperty("拨付占比")
    private BigDecimal appropriationProportion;


    @ApiModelProperty("预算模板-预算控制 是否开启 1开启 0关闭")
    private Integer budgetControlFlag;

    @ApiModelProperty("预算控制策略 0不控制")
    private String budgetControlStrategyFlag;

    @ApiModelProperty("预算科目明细")
    private List<PmsBudgetSubjectVO> subjectDetails;

    /**
     * 概算金额
     */
    @ApiModelProperty("概算金额")
    private BigDecimal probablyMoney;

    /**
     * 预算明细
     */
    @ApiModelProperty("预算明细")
    private List<PmsBudgetDetailVO> budgetDetailList;

    /**
     * 科目模板
     */
    @ApiModelProperty("科目模板")
    private List<PmsBudgetDetailSubjectVO> templateSubjectList;

    /**
     * 账户状态
     */
    @ApiModelProperty("账户状态")
    private String accountStatus;

    @ApiModelProperty("节点进度更新时间")
    private LocalDate wbsProgressUpdateTime;
}
