package com.elitesland.tw.tw5.api.prd.pms.vo;


import com.elitesland.tw.tw5.api.common.TwCommonVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 项目wbs前置依赖关系模板VO
 * @author wangxl
 * @date 2024/4/2
 */
@Data
@ApiModel(description = "项目wbs前置依赖关系模板vo")
public class PmsProjectWbsRelyTempVO extends TwCommonVO implements Serializable {

    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    @ApiModelProperty("项目主键名称")
    private String projectIdDesc;

    /**
     * wbs主键(依赖建立着，后置任务)
     */
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)")
    private Long wbsId;
    @ApiModelProperty("wbs主键(依赖建立着，后置任务)名称")
    private String wbsIdDesc;

    /**
     * wbs名称(依赖建立着，后置任务，冗余字段)
     */
    @ApiModelProperty("wbs名称(依赖建立着，后置任务，冗余字段)")
    private String wbsName;

    /**
     * wbs主键(依赖前置任务)
     */
    @ApiModelProperty("wbs主键(依赖前置任务)")
    private Long wbsRelyId;
    @ApiModelProperty("wbs主键(依赖前置任务)名称")
    private String wbsRelyIdDesc;

    /**
     * wbs名称(前置依赖名称，冗余字段）
     */
    @ApiModelProperty("wbs名称(前置依赖名称，冗余字段）")
    private String wbsRelyName;

    /**
     * 前置类型（FS）
     */
    @ApiModelProperty("前置类型（FS）")
    private String relyType;

    /**
     * 关系类型
     */
    @ApiModelProperty("关系类型")
    private String relationType;

    /**
     * 版本
     */
    @ApiModelProperty("版本")
    private Long versionId;
    @ApiModelProperty("版本名称")
    private String versionIdDesc;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    /**
     * 有效关联id
     */
    @ApiModelProperty("有效关联id")
    private Long effRelateId;
    @ApiModelProperty("有效关联id名称")
    private String effRelateIdDesc;

    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    /**
     * 数据归属组织id
     */
    @ApiModelProperty("数据归属组织id")
    private Long secBuId;
    @ApiModelProperty("数据归属组织id名称")
    private String secBuIdDesc;

    /**
     * 数据归属雇员id
     */
    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;
    @ApiModelProperty("数据归属雇员id名称")
    private String secUserIdDesc;

    /**
     * 数据归属公司id
     */
    @ApiModelProperty("数据归属公司id")
    private Long secOuId;
    @ApiModelProperty("数据归属公司id名称")
    private String secOuIdDesc;

}