package com.elitesland.tw.tw5.api.prd.purchase.vo;

import cn.hutool.core.date.DateUtil;
import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
@SearchBean(
        tables = "t_purchase_agreement agreement ",
        where = "agreement.delete_flag = 0",
        autoMapTo = "agreement"
)
public class PurchaseAgreementVO extends BaseViewModel implements Serializable {

    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("创建人名称")
    @ExcelProperty(index = 11, value = "创建人")
    @DbIgnore
    private String createUserName;

    @ApiModelProperty("记录创建时间")
    @DbIgnore
    private LocalDateTime createTimeStr;

    public String getCreateTimeStr() {
        return ObjectUtils.isEmpty(super.getCreateTime()) ? null : DateUtil.format(super.getCreateTime(), "yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 采购协议编号
     */
    @ApiModelProperty("采购协议编号")
    @ExcelProperty(index = 0, value = "协议编号")
    private String purchaseAgreementNo;
    /**
     * 采购协议名称
     */
    @ApiModelProperty("采购协议名称")
    @ExcelProperty(index = 1, value = "协议名称")
    private String purchaseAgreementName;
    /**
     * 协议类型 udc[purchase:agreement_type]
     */
    @ApiModelProperty("协议类型 udc[purchase:agreement_type]")
    private String agreementType;
    /**
     * 协议类型描述 udc[purchase:agreement_type]
     */
    @ApiModelProperty("协议类型 udc[purchase:agreement_type]")
    @UdcName(udcName = "purchase:agreement_type", codePropName = "agreementType")
    @DbIgnore
    private String agreementTypeDesc;
    /**
     * 验收方式 udc[purchase:check]
     */
    @ApiModelProperty("验收方式 udc[purchase:check]")
    private String acceptanceType;
    /**
     * 验收方式描述 udc[purchase:check]
     */
    @ApiModelProperty("验收方式描述 udc[purchase:check]")
    @UdcName(udcName = "purchase:check", codePropName = "acceptanceType")
    @ExcelProperty(index = 7, value = "验收方式")
    @DbIgnore
    private String acceptanceTypeDesc;
    /**
     * 签约日期
     */
    @ApiModelProperty("签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applicationDate;
    /**
     * 签约公司地址簿Id
     */
    @ApiModelProperty("签约公司地址簿Id")
    private Long signCompanyBookId;
    /**
     * 签约公司名称
     */
    @ApiModelProperty("签约公司名称")
    @ExcelProperty(index = 4, value = "签约公司")
    @DbIgnore
    private String signCompanyName;
    /**
     * 签约BU
     */
    @ApiModelProperty("签约BU")
    private Long signBuId;
    /**
     * 签约BU名称
     */
    @ApiModelProperty("签约BU名称")
    @UdcName(udcName = "BU", codePropName = "signBuId")
    @ExcelProperty(index = 5, value = "签约BU")
    @DbIgnore
    private String signBuName;
    /**
     * 签约负责人
     */
    @ApiModelProperty("签约负责人")
    private Long signInchargeResId;
    /**
     * 签约负责人名称
     */
    @ApiModelProperty("签约负责人名称")
    @UdcName(udcName = "USER", codePropName = "signInchargeResId")
    @ExcelProperty(index = 6, value = "签约负责人")
    @DbIgnore
    private String signInchargeResName;
    /**
     * 供应商地址簿ID
     */
    @ApiModelProperty("供应商地址簿ID")
    private Long supplierBookId;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @ExcelProperty(index = 3, value = "供应商")
    @DbIgnore
    private String supplierName;
    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currCode;
    /**
     * 币种描述 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种描述 udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    @DbIgnore
    private String currCodeDesc;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    @ExcelProperty(index = 8, value = "金额")
    private BigDecimal amt = BigDecimal.ZERO;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt = BigDecimal.ZERO;
    /**
     * 协议内容说明
     */
    @ApiModelProperty("协议内容说明")
    private String agreementContentDescription;
    /**
     * 比价资料
     */
    @ApiModelProperty("比价资料")
    private String pricecompereFileCodes;
    /**
     * 比价资料数据
     */
    @ApiModelProperty("比价资料数据")
    @DbIgnore
    private Object pricecompereFile;
    /**
     * 协议附件
     */
    @ApiModelProperty("协议附件")
    private String agreementFileCodes;
    /**
     * 协议附件数据
     */
    @ApiModelProperty("协议附件数据")
    @DbIgnore
    private Object agreementFile;
    /**
     * 盖章附件
     */
    @ApiModelProperty("盖章附件")
    private String stampFileCodes;
    /**
     * 盖章附件数据
     */
    @ApiModelProperty("盖章附件数据")
    @DbIgnore
    private Object stampFile;
    /**
     * 开票方
     */
    @ApiModelProperty("开票方")
    private Long invoice;
    /**
     * 开票方名称
     */
    @ApiModelProperty("开票方名称")
    @DbIgnore
    private String invoiceName;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String payMethod;
    @ApiModelProperty("付款方式描述")
    @UdcName(udcName = "ACC:PAY_METHOD", codePropName = "payMethod")
    @DbIgnore
    private String payMethodDesc;
    /**
     * 协议状态
     */
    @ApiModelProperty("协议状态")
    private String agreementStatus;
    /**
     * 协议状态描述
     */
    @ApiModelProperty("协议状态描述")
    @UdcName(udcName = "purchase:agreement_status", codePropName = "agreementStatus")
    @DbIgnore
    @ExcelProperty(index = 2, value = "协议状态")
    private String agreementStatusDesc;
    /**
     * 协议归属编号
     */
    @ApiModelProperty("协议归属编号")
    private String agreementOwnershipNo;
    /**
     * 激活时间
     */
    @ApiModelProperty("激活时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime activateDate;
    /**
     * 前置单据负责人
     */
    @ApiModelProperty("前置单据负责人")
    private Long preReceiptResId;
    @UdcName(udcName = "USER", codePropName = "preReceiptResId")
    @DbIgnore
    private Long preReceiptResName;
    /**
     * 终止原因
     */
    @ApiModelProperty("终止原因")
    private String overReason;
    /**
     * 终止日期
     */
    @ApiModelProperty("终止日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime overDate;
    /**
     * 采购明细
     */
    @ApiModelProperty("采购明细")
    @DbIgnore
    private List<PurchaseAgreementDetailsVO> details;
    /**
     * 有效开始日期
     */
    @ApiModelProperty("有效开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate effectiveStartDate;
    @ExcelProperty(index = 9, value = "有效开始日期")
    @DbIgnore
    private String effectiveStartDateStr;

    public String getEffectiveStartDateStr() {
        return ObjectUtils.isEmpty(this.getEffectiveStartDate()) ? null : this.getEffectiveStartDate().toString();
    }

    /**
     * 有效结束日期
     */
    @ApiModelProperty("有效结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate effectiveEndDate;
    @ExcelProperty(index = 10, value = "有效结束日期")
    @DbIgnore
    private String effectiveEndDateStr;

    public String getEffectiveEndDateStr() {
        return ObjectUtils.isEmpty(this.getEffectiveEndDate()) ? null : this.getEffectiveEndDate().toString();
    }

    /**
     * 流程实例ID
     */
    private String procInstId;

    /**
     * 流程审批状态
     */
    private ProcInstStatus procInstStatus;
    @DbIgnore
    private String procInstStatusDesc;

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;


    /**
     * 需求编号 -- 先忽略
     */
    @DbIgnore
    private String demandNo;

    /**
     * 收款人/单位编码
     */
    @DbField(mapTo = "agreement", value = "supplier_book_id")
    private Long receivingUnitBookId;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("创建时间")
    @DbIgnore
    @ExcelProperty(index = 12, value = "创建时间")
    private String createTimeString;

    public String getCreateTimeString() {
        if(getCreateTime()!=null){
            return getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return createTimeString;
    }
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除标识
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    /**
     * 锁版本
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    @DbIgnore
    @ApiModelProperty("BU名称")
    private String buName;

    @DbIgnore
    @ApiModelProperty("评级")
    private String grade;

    @DbIgnore
    @ApiModelProperty("供应商状态")
    private String supplierStatus;


    @DbIgnore
    @ApiModelProperty("供应商id")
    private Long supplierParentId;

    @DbIgnore
    @ApiModelProperty("创建人buId")
    private Long buId;

    @DbIgnore
    @ApiModelProperty("打印归档用户id")
    private String printUserId;
}
