package com.elitesland.tw.tw5.api.prd.purchase.vo;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@SearchBean(
        distinct = true,
        tables = "t_purchase_contract_manager pcm " +
                "left join t_purchase_contract_details pcd on pcm.id = pcd.purchase_contract_id and pcd.delete_flag=0 " +
                "left join sale_con_contract scc on scc.id = pcm.related_sales_contract and scc.delete_flag=0 " +
                "left join pms_project pp on pp.id = pcm.related_project_id and pp.delete_flag=0 " +
                "left join prd_product ppt on ppt.id = pcd.related_product_id and ppt.delete_flag=0 " +
                "left join prd_product_class ppc on ppc.id = ppt.class_id and ppc.delete_flag=0 ",
        where = "pcm.delete_flag = 0",
        groupBy = "pcm.id",
        autoMapTo = "pcm"
)


@Getter
@Setter
@ExcelIgnoreUnannotated
public class PurchaseContractManagerVO extends BaseViewModel implements Serializable {
    /**
     * 提交人用户id
     */
    @ApiModelProperty("提交人用户id")
    private Long createUserId;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    @UdcName(udcName = "USER", codePropName = "createUserId")
    @ExcelProperty(index = 13, value = "创建人")
    @DbIgnore
    private String createUserName;
    @ApiModelProperty("记录创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    @ExcelProperty(index = 15, value = "记录创建时间")
    @DbIgnore
    private String createTimeStr;

    public String getCreateTimeStr() {
        return ObjectUtils.isEmpty(this.createTime) ? null : LocalDateTimeUtil.format(this.createTime, DatePattern.NORM_DATETIME_PATTERN);
    }

    /**
     * 采购合同编号
     */
    @ApiModelProperty("采购合同编号")
    @ExcelProperty(index = 0, value = "采购合同编号")
    private String purchaseContractNo;

    /**
     * 采购合同名称
     */
    @ApiModelProperty("采购合同名称")
    @ExcelProperty(index = 1, value = "采购合同名称")
    private String purchaseContractName;

    /**
     * 平台合同类型 udc[salecon:plat_type]
     */
    @ApiModelProperty("平台合同类型 udc[salecon:plat_type]")
    private String platType;

    /**
     * 平台合同类型描述 udc[salecon:plat_type]
     */
    @ApiModelProperty("平台合同类型描述 udc[salecon:plat_type]")
    @UdcName(udcName = "salecon:plat_type", codePropName = "platType")
    @DbIgnore
    private String platTypeDesc;

    /**
     * 采购合同类型 udc[purchase:con_type]
     */
    @ApiModelProperty("采购合同类型 udc[purchase:con_type]")
    private String purchaseContractType;

    /**
     * 采购合同类型描述 udc[purchase:con_type]
     */
    @ApiModelProperty("采购合同类型描述 udc[purchase:con_type]")
    @UdcName(udcName = "purchase:con_type", codePropName = "purchaseContractType")
    @DbIgnore
    private String purchaseContractTypeDesc;

    /**
     * 业务类型 udc[purchase:business_type]
     */
    @ApiModelProperty("业务类型 udc[purchase:business_type]")
    private String businessType;

    /**
     * 业务类型描述 udc[purchase:business_type]
     */
    @ApiModelProperty("业务类型描述 udc[purchase:business_type]")
    @UdcName(udcName = "purchase:business_type", codePropName = "businessType")
    @ExcelProperty(index = 4, value = "业务类型")
    @DbIgnore
    private String businessTypeDesc;

    /**
     * 验收方式 udc[purchase:check]
     */
    @ApiModelProperty("验收方式 udc[purchase:check]")
    private String acceptanceType;

    /**
     * 验收方式描述 udc[purchase:check]
     */
    @ApiModelProperty("验收方式描述 udc[purchase:check]")
    @UdcName(udcName = "purchase:check", codePropName = "acceptanceType")
    @DbIgnore
    private String acceptanceTypeDesc;

    /**
     * 采购公司地址簿Id
     */
    @ApiModelProperty("采购公司地址簿Id")
    private Long purchaseCompanyBookId;

    /**
     * 采购公司名称
     */
    @ApiModelProperty("采购公司名称")
    @ExcelProperty(index = 5, value = "采购公司")
    @DbIgnore
    private String purchaseCompanyName;


    /**
     * 供应商BookID
     */
    @ApiModelProperty("供应商BookID")
    private Long supplierBookId;

    @ApiModelProperty("供应商")
    @ExcelProperty(index = 8, value = "供应商")
    @DbIgnore
    private String supplierName;

    /**
     * 采购BU
     */
    @ApiModelProperty("采购BU")
    private Long purchaseBuId;

    /**
     * 采购BU名称
     */
    @ApiModelProperty("采购BU名称")
    @ExcelProperty(index = 6, value = "采购BU")
    @DbIgnore

    private String purchaseBuName;

    /**
     * 采购负责人
     */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;

    /**
     * 采购负责人名称
     */
    @ApiModelProperty("采购负责人名称")
    @ExcelProperty(index = 7, value = "采购负责人")
    @DbIgnore
    private String purchaseInchargeResName;

    /**
     * 签约日期
     */
    @ApiModelProperty("签约日期")
    private LocalDate signDate;
    @ExcelProperty(index = 9, value = "签约日期", format = "yyyy-MM-dd")
    @DbIgnore
    private String signDateStr;

    public String getSignDateStr() {
        return ObjectUtils.isEmpty(this.signDate) ? null : this.signDate.toString();
    }

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applicationDate;

    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currCode;

    /**
     * 币种描述 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种描述 udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    @DbIgnore
    private String currCodeDesc;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    @ExcelProperty(index = 2, value = "金额")
    private BigDecimal amt = BigDecimal.ZERO;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String taxRate;

    /**
     * 税率描述
     */
    @ApiModelProperty("税率描述")
    @UdcName(udcName = "prd:ab:tax_rate", codePropName = "taxRate")
    @DbIgnore
    private String taxRateDesc;

    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt = BigDecimal.ZERO;

    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    private String contractStatus;

    /**
     * 合同状态描述
     */
    @ApiModelProperty("合同状态描述")
    @UdcName(udcName = "purchase:status", codePropName = "contractStatus")
    @ExcelProperty(index = 3, value = "采购合同状态")
    @DbIgnore
    private String contractStatusDesc;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;

    /**
     * 审批状态描述
     */
    @ApiModelProperty("审批状态描述")
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    @DbIgnore
    private String apprStatusDesc;

    /**
     * 关联销售合同
     */
    @ApiModelProperty("关联销售合同")
    private Long relatedSalesContract;

    /**
     * 关联销售合同名称
     */
    @ApiModelProperty("关联销售合同名称")
    @ExcelProperty(index = 11, value = "关联销售合同")
    @DbField(mapTo = "scc", value = "name")
    private String relatedSalesContractName;
    /**
     * 关联销售合同名称
     */
    @ApiModelProperty("关联销售合同编号")
    @DbField(mapTo = "scc", value = "code")
    private String relatedSalesContractCode;

    /**
     * 关联协议
     */
    @ApiModelProperty("关联协议")
    private Long relatedAgreement;

    /**
     * 需求编号
     */
    @ApiModelProperty("需求编号")
    private String demandNo;

    /**
     * 比价资料
     */
    @ApiModelProperty("比价资料")
    private String pricecompereFileCodes;

    /**
     * 比价资料文件数据
     */
    @ApiModelProperty("比价资料文件数据")
    @DbIgnore
    private Object pricecompereFile;

    /**
     * 合同附件
     */
    @ApiModelProperty("合同附件")
    private String contractFileCodes;

    /**
     * 合同附件数据
     */
    @ApiModelProperty("合同附件数据")
    @DbIgnore
    private Object contractFile;

    /**
     * 盖章附件
     */
    @ApiModelProperty("盖章附件")
    private String stampFileCodes;

    /**
     * 盖章附件数据
     */
    @ApiModelProperty("盖章附件数据")
    @DbIgnore
    private Object stampFile;

    /**
     * 项目ID
     */
    @ApiModelProperty("项目ID")
    private Long relatedProjectId;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @ExcelProperty(index = 12, value = "相关项目")
    @DbField(mapTo = "pp", value = "proj_name")
    private String relatedProjectName;

    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    @ExcelProperty(index = 16, value = "相关项目")
    @DbField(mapTo = "pp", value = "proj_no")
    private String relatedProjectNo;

    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    @DbField(mapTo = "pp", value = "proj_no")
    private String relatedProjectCode;

    /**
     * 任务包
     */
    @ApiModelProperty("任务包")
    private Long relatedTask;

    /**
     * 开票方
     */
    @ApiModelProperty("开票方")
    private Long invoice;

    /**
     * 开票方名称
     */
    @ApiModelProperty("开票方名称")
    @ExcelProperty(index = 10, value = "开票方")
    @DbIgnore
    private String invoiceName;

    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String payMethod;

    /**
     * 付款方式描述
     */
    @ApiModelProperty("付款方式描述")
    @UdcName(udcName = "ACC:PAY_METHOD", codePropName = "payMethod")
    @DbIgnore
    private String payMethodDesc;

    /**
     * 采购来源
     */
    @ApiModelProperty("采购来源")
    private String contractSource;

    /**
     * 采购来源编号
     */
    @ApiModelProperty("采购来源编号")
    private String contractSourceNo;

    /**
     * 激活时间
     */
    @ApiModelProperty("激活时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime activateDate;

    /**
     * 终止原因
     */
    @ApiModelProperty("终止原因")
    private String overWhy;

    /**
     * 终止时间
     */
    @ApiModelProperty("终止时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime overDate;

    /**
     * 合同归档标志，0：未归档，1：归档
     */
    @ApiModelProperty("合同归档标志，0：未归档，1：归档")
    private Integer filingFlag;

    @ExcelProperty(index = 14, value = "是否归档")
    @DbIgnore
    private String filingFlagDesc;

    public String getFilingFlagDesc() {
        return ObjectUtils.isEmpty(this.filingFlag) || 0 == this.filingFlag ? "否" : "是";
    }

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime approvedTime;

    // 采购合同明细
    @DbIgnore
    private List<PurchaseContractDetailsVO> purchaseDetailViews;

    // 采购付款计划
    @DbIgnore
    private List<PurchasePaymentPlanVO> paymentPlanViews;

    // 销售合同信息
    @DbIgnore
    private SaleConContractVO saleContractView;

    // 项目信息
    //private  projectInfoView;

    @ApiModelProperty("采购大类")
    @DbIgnore
    private String productClass;

    @ApiModelProperty("采购大类描述")
    @UdcName(udcName = "con:purchase_type", codePropName = "productClass")
    @DbIgnore
    private String productClassDesc;

    @ApiModelProperty("采购小类描述")
    @DbIgnore
    private String productSubClass;
    @ApiModelProperty("采购小类描述")
    @DbIgnore
    private String productSubClassDesc;

    @ApiModelProperty("关联产品")
    @DbIgnore
    private Long productId;

    @ApiModelProperty("产品名称")
    @DbIgnore
    private String productName;

    @ApiModelProperty("采购内容简述")
    @DbIgnore
    private String demandSaid;

    @DbIgnore
    private TPurchaseContractOverVO overVO;

    @ApiModelProperty("关闭原因")
    @DbIgnore
    private String closeReason;

    /**
     * 关闭日期
     */
    @ApiModelProperty("关闭日期")
    @DbIgnore
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate closeDate;

    /**
     * 产品大类
     */
    // @DbField(mapTo = "pcd")
    @ApiModelProperty("产品大类")
    @DbField(mapTo = "ppc", value = "id")
    private Long classId;

    /**
     * 合同名称/编号
     */
    @ApiModelProperty("合同名称")
    //@DbField(mapTo = "scc", value = "name")
    @DbIgnore
    private String contractName;

    /**
     * 合同名称/编号
     */
    @ApiModelProperty("合同编号")
    //@DbField(mapTo = "scc", value = "code")
    @DbIgnore
    private String contractNo;

    /**
     * 项目名称/编号
     */
    @DbIgnore
    @ApiModelProperty("项目名称/编号")
    private String projNmNo;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除标识
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    /**
     * 锁版本
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    /**
     * 采购明细中采购大小类id （默认取第一条）
     */
    @DbIgnore
    private Long detailProductClassId;
    @DbIgnore
    private String detailProductClassName;
    @DbIgnore
    private Long detailSubProductClassId;
    @DbIgnore
    private String detailSubProductClassName;

    @DbIgnore
    @ApiModelProperty("BU名称")
    private String buName;

    @DbIgnore
    @ApiModelProperty("评级")
    private String grade;


    @DbIgnore
    @ApiModelProperty("供应商状态")
    private String supplierStatus;


    @DbIgnore
    @ApiModelProperty("供应商id")
    private Long supplierParentId;

    @DbIgnore
    @ApiModelProperty("付款记录付款金额")
    private BigDecimal paymentAmt;

    @DbIgnore
    @ApiModelProperty("销售子合同签单BU")
    private Long saleSignBuId = -1L;

    @DbIgnore
    @ApiModelProperty("项目交付BU")
    private Long prjDeliBuId = -1L;

    @DbIgnore
    @ApiModelProperty("申请人一级BU负责人")
    private Long buLevel1BuLeaderId ;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;
}
