package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.OrgGrossProfitRateSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.OrgGrossProfitRateSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.OrgGrossProfitRateSettingVO;

import java.util.List;

/**
 * 部门毛利率配置
 *
 * @author wangly
 * @date 2024-04-01
 */
public interface OrgGrossProfitRateSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link OrgGrossProfitRateSettingVO}>
     */
    PagingVO<OrgGrossProfitRateSettingVO> queryPaging(OrgGrossProfitRateSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link OrgGrossProfitRateSettingVO}>
     */
    List<OrgGrossProfitRateSettingVO> queryListDynamic(OrgGrossProfitRateSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link OrgGrossProfitRateSettingVO}
     */
    OrgGrossProfitRateSettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link OrgGrossProfitRateSettingVO}
     */
    OrgGrossProfitRateSettingVO insert(OrgGrossProfitRateSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link OrgGrossProfitRateSettingVO}
     */
    OrgGrossProfitRateSettingVO update(OrgGrossProfitRateSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(OrgGrossProfitRateSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
