package com.elitesland.tw.tw5.api.prd.system.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import com.elitesland.tw.tw5.api.common.annotation.Query;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Getter
@Setter
public class PrdSystemGrossMarginQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /** BU_ID 精确 */
    @ApiModelProperty("BU_ID")
    @Query
    private Long buId;
    /** 年度 精确 */
    @ApiModelProperty("年度")
    @Query
    private Integer yearly;
    /** 合同金额 精确 */
    @ApiModelProperty("合同金额")
    @Query
    private BigDecimal amt;
    /** BU负责人ID 精确 */
    @ApiModelProperty("BU负责人ID")
    @Query
    private Long buDirectorId;
    /** BU毛利率 精确 */
    @ApiModelProperty("BU毛利率")
    @Query
    private Integer buGrossMargin;
    /** 阶梯毛利率1 精确 */
    @ApiModelProperty("阶梯毛利率1")
    @Query
    private Integer ladderGrossMargin1;
    /** 阶梯负责人1ID 精确 */
    @ApiModelProperty("阶梯负责人1ID")
    @Query
    private Long ladderDirectorId1;
    /** 阶梯毛利率2 精确 */
    @ApiModelProperty("阶梯毛利率2")
    @Query
    private Integer ladderGrossMargin2;
    /** 阶梯负责人2ID 精确 */
    @ApiModelProperty("阶梯负责人2ID")
    @Query
    private Long ladderDirectorId2;
}
