package com.elitesland.tw.tw5.api.prd.task.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Getter
@Setter
public class TaskInfoPayload extends TwCommonPayload implements Serializable {

    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("任务包ID")
    private Long taskPackageId;
    @ApiModelProperty("上级任务ID")
    private Long taskParentId;
    @ApiModelProperty("上级任务名称")
    private String taskParentName;
    @ApiModelProperty("任务编号")
    private String taskNo;
    @ApiModelProperty("任务名称")
    private String taskName;
    @ApiModelProperty("任务负责人")
    private Long taskResId;
    @ApiModelProperty("派发资源id")
    private Long disterResId;
    @ApiModelProperty("协助人")
    private Long assId;
    @ApiModelProperty("关联活动")
    private Long relatedActId;
    @ApiModelProperty("关联活动")
    private String relatedAct;
    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    @ApiModelProperty("任务类型")
    private String taskType;
    @ApiModelProperty("任务来源类型null或1是普通任务，2奖励假任务,3帮我吧工时创建")
    private String sourceType;
    @ApiModelProperty("来源id（如果是奖励假申请则是奖励假申请id）")
    private Long sourceId;
    @ApiModelProperty("任务描述")
    private String taskDes;
    @ApiModelProperty("任务验收标准")
    private String accepCriteria;
    @ApiModelProperty("优先级")
    private Integer priority;
    @ApiModelProperty("任务总当量数")
    private BigDecimal totalEqva;
    @ApiModelProperty("已结算当量数")
    private BigDecimal settledEqva;
    @ApiModelProperty("计划当量数")
    private BigDecimal planEqva;
    @ApiModelProperty("原始当量数")
    private BigDecimal originalEqva;
    @ApiModelProperty("追加当量数")
    private BigDecimal additionEqva;
    @ApiModelProperty("拆分当量数")
    private BigDecimal splitEqva;
    @ApiModelProperty("已使用当量")
    private BigDecimal usedEqva;
    @ApiModelProperty("释放当量数")
    private BigDecimal releaseEqva;
    @ApiModelProperty("工时已审批通过当量")
    private BigDecimal approvedEqva;
    @ApiModelProperty("有效当量数")
    private BigDecimal validEqva;
    @ApiModelProperty("是否评价:1已经评价过 0没有")
    private Integer evaluationflag;
    @ApiModelProperty("任务进度")
    private BigDecimal taskProgress;
    @ApiModelProperty("任务状态")
    private String taskStatus;
    @ApiModelProperty("发起变更流程标记")
    private Boolean changeFlag;

    @ApiModelProperty("变更Id")
    private Long changeId;

    @ApiModelProperty("变更说明")
    private String changeDes;

    @ApiModelProperty("任务申请标记")
    private Integer taskApplyFlag;

    @ApiModelProperty("任务申请流程Id")
    private String taskApplyProcessId;

    @ApiModelProperty("实际开始日期")
    private LocalDate actualStartDate;
    @ApiModelProperty("实际结束日期")
    private LocalDate actualEndDate;
//    /**
//     * 拆分任务标记
//     */
//    private Integer splitFlag;
    /**
     * 来源帮我吧标记 1：是
     */
    @ApiModelProperty(value = "来源帮我吧标记 1：是")
    private Integer bw8Flag;



    /**
     * 状态流id
     */
    @ApiModelProperty("状态流id")
    private Long stateFlowId;
    private String stateFlowName;

    /**
     * 参考任务进度
     */
    @ApiModelProperty("参考任务进度")
    private BigDecimal referenceTaskProgress;


    @ApiModelProperty("状态流编码")
    private String stateFlowCode;


    @ApiModelProperty("状态流版本")
    private Integer stateFlowVersionNo;

    /**
     * 任务场景id(任务类别)
     */
    @ApiModelProperty("任务场景id")
    private Long taskSceneId;

    /**
     * 项目分组ID
     */
    @ApiModelProperty("项目分组ID")
    private Long groupId;
}
